/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.categories;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.cms.tag.jcr.JCRTag;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.UnknownAmetysObjectException;
import org.ametys.plugins.workspaces.categories.CategoryJCR;
import org.ametys.plugins.workspaces.categories.CategoryJCRProvider;
import org.ametys.plugins.workspaces.categories.CategoryProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang.StringUtils;

public class CategoryJCRDAO
extends AbstractJCRTagsDAO {
    public static final String ROLE = CategoryJCRDAO.class.getName();
    public static final String COLOR_ATTRIBUTE_NAME = "color";
    protected CategoryProviderExtensionPoint _tagProviderExtPt;
    protected RightManager _rightManager;

    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._tagProviderExtPt = (CategoryProviderExtensionPoint)((Object)serviceManager.lookup(CategoryProviderExtensionPoint.ROLE));
        this._rightManager = (RightManager)serviceManager.lookup(RightManager.ROLE);
    }

    public ModifiableTraversableAmetysObject _getTagRootObject(String tagProviderId, Map<String, Object> contextualParameters) throws RepositoryException {
        CategoryJCRProvider provider = (CategoryJCRProvider)((Object)this._tagProviderExtPt.getExtension(tagProviderId));
        return provider.getRootNode(contextualParameters);
    }

    protected void _checkUserRight() throws IllegalStateException {
        String context = "/admin";
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, "Workspace_Rights_Categories_HandleCategory", (Object)context) != RightManager.RightResult.RIGHT_ALLOW) {
            this.getLogger().error("User '" + user + "' tried to access a privileged feature without convenient right. Should have right 'Workspace_Rights_Categories_HandleCategory' on context '" + context + "'");
            throw new IllegalStateException("You have no right to access this feature.");
        }
    }

    protected Tag _getTagFromName(String name, Map<String, Object> contextualParameters) {
        return this._tagProviderExtPt.getTag(name, contextualParameters);
    }

    protected JCRTag _createJCRTag(String parentId, String name, String title, String description, Map<String, Object> otherParameters, Map<String, Object> contextualParameters) throws RepositoryException {
        ModifiableTraversableAmetysObject parent = null;
        parent = StringUtils.isEmpty((String)parentId) ? this._getTagRootObject(CategoryJCRProvider.class.getName(), contextualParameters) : (ModifiableTraversableAmetysObject)this._resolver.resolveById(parentId);
        CategoryJCR jcrCategory = (CategoryJCR)parent.createChild(name, "ametys:project-category");
        jcrCategory.setTitle(title);
        jcrCategory.setDescription(description);
        String color = (String)otherParameters.get(COLOR_ATTRIBUTE_NAME);
        if (StringUtils.isNotBlank((String)color)) {
            jcrCategory.setColor(color);
        }
        parent.saveChanges();
        return jcrCategory;
    }

    protected JCRTag _updateJCRTag(String tagId, String title, String description, Map<String, Object> otherParameters) throws UnknownAmetysObjectException {
        String color = (String)otherParameters.get(COLOR_ATTRIBUTE_NAME);
        CategoryJCR jcrCategory = (CategoryJCR)this._resolver.resolveById(tagId);
        jcrCategory.setTitle(title);
        jcrCategory.setDescription(description);
        if (StringUtils.isNotBlank((String)color)) {
            jcrCategory.setColor(color);
        } else {
            jcrCategory.setColor("");
        }
        jcrCategory.saveChanges();
        return jcrCategory;
    }

    protected Set<TagProvider<? extends Tag>> _getTagProviders() {
        HashSet<TagProvider<? extends Tag>> providers = new HashSet<TagProvider<? extends Tag>>();
        Set ids = this._tagProviderExtPt.getExtensionsIds();
        for (String id : ids) {
            TagProvider provider = (TagProvider)this._tagProviderExtPt.getExtension(id);
            providers.add((TagProvider<? extends Tag>)provider);
        }
        return providers;
    }

    @Callable(rights={"Workspace_Rights_Categories_HandleCategory"}, context="/admin")
    public Map<String, Object> getTagRootNode(String tagProviderId, Map<String, Object> contextualParameters) throws ProcessingException {
        return super.getTagRootNode(tagProviderId, contextualParameters);
    }

    @Callable(rights={"Workspace_Rights_Categories_HandleCategory"}, context="/admin")
    public Map<String, Object> getTag(String tagId) {
        return super.getTag(tagId);
    }
}

