/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.chat;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.GroupManager;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.chat.ChatHelper;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class MemberRemovedObserver
extends AbstractLogEnabled
implements Observer,
Serviceable {
    protected ChatHelper _chatHelper;
    private GroupManager _groupManager;
    private ProjectMemberManager _projectMemberManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._chatHelper = (ChatHelper)((Object)manager.lookup(ChatHelper.ROLE));
        this._groupManager = (GroupManager)manager.lookup(GroupManager.ROLE);
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
    }

    public boolean supports(Event event) {
        return "member.deleted".equals(event.getId()) && (Boolean)Config.getInstance().getValue("workspaces.chat.active") != false;
    }

    public int getPriority(Event event) {
        return 0;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception {
        Set users;
        Project project = (Project)((Object)event.getArguments().get("project"));
        String memberIdentity = (String)event.getArguments().get("project.member.identity");
        JCRProjectMember.MemberType memberType = (JCRProjectMember.MemberType)((Object)event.getArguments().get("project.member.identity.type"));
        if (memberType == JCRProjectMember.MemberType.USER) {
            users = Set.of(UserIdentity.stringToUserIdentity((String)memberIdentity));
        } else {
            GroupIdentity groupIdentity = GroupIdentity.stringToGroupIdentity((String)memberIdentity);
            Group group = this._groupManager.getGroup(groupIdentity);
            users = group.getUsers();
        }
        Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, true);
        Set stillMembers = projectMembers.stream().map(m -> m.getUser().getIdentity()).collect(Collectors.toSet());
        for (UserIdentity user : users) {
            if (stillMembers.contains(user)) continue;
            try {
                this._chatHelper.removeUserFromRoom(user, project.getName());
            }
            catch (IOException e) {
                this.getLogger().error("An error occurred that prevented the user " + UserIdentity.userIdentityToString((UserIdentity)user) + " to be removed from the room " + project.getName(), (Throwable)e);
            }
        }
    }
}

