/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.chat;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.Map;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang3.StringUtils;

public class VideoRedirectionAction
extends ServiceableAction
implements Initializable,
ThreadSafe {
    private CurrentUserProvider _currentUserProvider;
    private UserManager _userManager;
    private MessageDigest _digest;
    private I18nUtils _i18nUtils;
    private Base64.Encoder _base64Encoder;
    private ProjectMemberManager _projectMemberManager;
    private ProjectManager _projectManager;
    private UserDirectoryHelper _userDirectoryHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)smanager.lookup(UserManager.ROLE);
        this._i18nUtils = (I18nUtils)smanager.lookup(I18nUtils.ROLE);
        this._projectManager = (ProjectManager)((Object)smanager.lookup(ProjectManager.ROLE));
        this._projectMemberManager = (ProjectMemberManager)((Object)smanager.lookup(ProjectMemberManager.ROLE));
        this._userDirectoryHelper = (UserDirectoryHelper)smanager.lookup(UserDirectoryHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._digest = MessageDigest.getInstance("SHA-256");
        this._base64Encoder = Base64.getUrlEncoder().withoutPadding();
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        String videoType = parameters.getParameter("type", "room");
        String target = parameters.getParameter("target", null);
        if (userIdentity != null && target != null) {
            User user = this._userManager.getUser(userIdentity);
            this._checkRights(videoType, target, user);
            String url = Config.getInstance().getValue("workspaces.chat.video.url") + "/" + this._hash(videoType, target) + "/" + URIUtils.encodePathSegment((String)this._readable(videoType, target)) + "#" + URIUtils.encodeFragment((String)this._config(user));
            redirector.globalRedirect(false, url);
        }
        return null;
    }

    private void _checkRights(String videoType, String target, User user) {
        if ("room".equals(videoType)) {
            Project project = this._projectManager.getProject(target);
            if (project == null) {
                throw new IllegalStateException("There is no project named " + target);
            }
            if (!this._projectMemberManager.isProjectMember(project, user.getIdentity())) {
                throw new AccessDeniedException("User " + UserIdentity.userIdentityToString((UserIdentity)user.getIdentity()) + " cannot connect to the video of project " + target);
            }
        }
    }

    private String _readable(String videoType, String target) {
        if ("room".equals(videoType)) {
            return target;
        }
        return this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_CHAT_VIDEO_DIRECT_LINK_TITLE"));
    }

    private String _hash(String videoType, String target) {
        String tohash = "room".equals(videoType) ? target : target;
        return this._base64Encoder.encodeToString(this._digest.digest(tohash.getBytes(StandardCharsets.UTF_8)));
    }

    private String _config(User user) {
        String userFullname = user.getFullName();
        String userEmail = user.getEmail();
        Content userContent = this._userDirectoryHelper.getUserContent(user.getIdentity(), null);
        if (userContent != null) {
            userFullname = (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.join((Object[])new String[]{(String)userContent.getValue("firstname"), (String)userContent.getValue("lastname")}, (String)" "), (CharSequence)userFullname);
            userEmail = (String)StringUtils.defaultIfBlank((CharSequence)((String)userContent.getValue("email")), (CharSequence)userEmail);
        }
        return "userInfo.displayName=\"" + userFullname + "\"&userInfo.email=\"" + userEmail + "\"&config.disableInviteFunctions=true&config.prejoinPageEnabled=false&config.requireDisplayName=false";
    }
}

