/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.dav;

import java.io.IOException;
import java.util.Map;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WebdavLockGenerator
extends AbstractGenerator
implements Serviceable {
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        ModifiableResource resource = (ModifiableResource)request.getAttribute("resource");
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        response.setHeader("Lock-Token", "<" + resource.getId() + ">");
        response.setHeader("Content-Type", "application/xml; charset=utf-8");
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("d", "DAV:");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:prop");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:lockdiscovery");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:activelock");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:locktype");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:write");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:locktype");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:lockscope");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:exclusive");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:lockscope");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:depth", (String)"infinity");
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:locktoken");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:href", (String)resource.getId());
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:locktoken");
        boolean unlockActive = (Boolean)Config.getInstance().getValue("content.unlocktimer.activate");
        long unlockTimer = (Long)Config.getInstance().getValue("content.unlocktimer.period");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:timeout", (String)(unlockActive ? "Second-" + String.valueOf(3600L * unlockTimer) : "Infinite"));
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:owner", (String)UserIdentity.userIdentityToString((UserIdentity)this._currentUserProvider.getUser()));
        String href = ResolveURIComponent.resolve((String)"webdav-project-resource", (String)resource.getId(), (boolean)false, (boolean)true);
        XMLUtils.startElement((ContentHandler)this.contentHandler, (String)"d:lockroot");
        XMLUtils.createElement((ContentHandler)this.contentHandler, (String)"d:href", (String)href);
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:lockroot");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:activelock");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:lockdiscovery");
        XMLUtils.endElement((ContentHandler)this.contentHandler, (String)"d:prop");
        this.contentHandler.endDocument();
    }
}

