/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.query.DocumentTypeQuery;
import org.ametys.cms.search.query.FilenameQuery;
import org.ametys.cms.search.query.FullTextQuery;
import org.ametys.cms.search.query.MatchAllQuery;
import org.ametys.cms.search.query.MimeTypeGroupQuery;
import org.ametys.cms.search.query.OrQuery;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.StringQuery;
import org.ametys.cms.search.solr.SearcherFactory;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.transformation.xslt.ResolveURIComponent;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.DateUtils;
import org.ametys.core.util.FilenameUtils;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.explorer.ExplorerNode;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.explorer.threads.jcr.JCRPost;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableAmetysObject;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.JCRTraversableAmetysObject;
import org.ametys.plugins.repository.lock.LockableAmetysObject;
import org.ametys.plugins.repository.tag.TagAwareAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObject;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.DocumentWorkspaceModule;
import org.ametys.plugins.workspaces.documents.onlyoffice.OnlyOfficeManager;
import org.ametys.plugins.workspaces.html.HTMLTransformer;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.search.query.KeywordQuery;
import org.ametys.plugins.workspaces.search.query.ProjectQuery;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.PartName;

public class WorkspaceExplorerResourceDAO
extends ExplorerResourcesDAO
implements PluginAware {
    public static final String ROLE = WorkspaceExplorerResourceDAO.class.getName();
    protected AddOrUpdateResourceHelper _addOrUpdateResourceHelper;
    private ProjectManager _projectManager;
    private SearcherFactory _searcherFactory;
    private WorkspaceModuleExtensionPoint _moduleEP;
    private WorkspacesHelper _workspaceHelper;
    private OnlyOfficeManager _onlyOfficeManager;
    private HTMLTransformer _htmlTransformer;
    private SourceResolver _sourceResolver;
    private ProjectMemberManager _projectMemberManager;
    private UserManager _userManager;
    private String _pluginName;
    private ProjectTagProviderExtensionPoint _tagProviderExtensionPoint;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._htmlTransformer = (HTMLTransformer)((Object)manager.lookup(HTMLTransformer.ROLE));
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._addOrUpdateResourceHelper = (AddOrUpdateResourceHelper)manager.lookup(AddOrUpdateResourceHelper.ROLE);
        this._searcherFactory = (SearcherFactory)manager.lookup(SearcherFactory.ROLE);
        this._moduleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._onlyOfficeManager = (OnlyOfficeManager)((Object)manager.lookup(OnlyOfficeManager.ROLE));
        this._tagProviderExtensionPoint = (ProjectTagProviderExtensionPoint)((Object)manager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._projectMemberManager = (ProjectMemberManager)((Object)manager.lookup(ProjectMemberManager.ROLE));
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    @Callable
    public Map<String, Object> addFolder(String parentId, String inputName, String description) throws IllegalAccessException {
        return this.addFolder(parentId, inputName, description, false);
    }

    @Callable
    public Map<String, Object> addFolder(String parentId, String inputName, String description, Boolean renameIfExists) {
        ResourceCollection document = this._getRootIfNull(parentId);
        if (document == null) {
            throw new IllegalArgumentException("Unable to add folder: parent folder not found");
        }
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Add", (Object)document) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to add folder without convenient right [Plugin_Explorer_Folder_Add]");
        }
        if (!(document instanceof ModifiableResourceCollection)) {
            throw new IllegalClassException(ModifiableResourceCollection.class, document.getClass());
        }
        LinkedList errors = new LinkedList();
        ResourceCollection collection = this.addResourceCollection((ModifiableResourceCollection)document, inputName, renameIfExists, errors);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!errors.isEmpty()) {
            result.put("message", errors.get(0));
            result.put("error", true);
        }
        if (collection != null) {
            if (StringUtils.isNotBlank((CharSequence)description)) {
                ((ModifiableResourceCollection)collection).setDescription(description);
            }
            ((ModifiableResourceCollection)collection).saveChanges();
            result.putAll(this._extractFolderData(collection));
        }
        return result;
    }

    @Callable
    public Map<String, Object> moveObjects(List<String> objectIds, String parentFolderId) throws RepositoryException {
        for (String id : objectIds) {
            String rightId;
            AmetysObject object = this._resolver.resolveById(id);
            String string = rightId = object instanceof JCRResourcesCollection ? "Plugin_Explorer_Folder_Edit" : "Plugin_Explorer_File_Rename";
            if (this._rightManager.hasRight(this._currentUserProvider.getUser(), rightId, (Object)object) == RightManager.RightResult.RIGHT_ALLOW) continue;
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to move file or folder without convenient right [" + rightId + "]");
        }
        JCRResourcesCollection parentFolder = (JCRResourcesCollection)this._resolver.resolveById(parentFolderId);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Edit", (Object)parentFolder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to edit folder without convenient right [Plugin_Explorer_Folder_Edit]");
        }
        Map results = this.moveObject(objectIds, (JCRTraversableAmetysObject)parentFolder);
        if (results.containsKey("moved-objects")) {
            ArrayList<String> movedFolders = new ArrayList<String>();
            ArrayList<String> movedFiles = new ArrayList<String>();
            List movedObjects = (List)results.get("moved-objects");
            for (String objectId : movedObjects) {
                AmetysObject object = this._resolver.resolveById(objectId);
                if (object instanceof JCRResourcesCollection) {
                    movedFolders.add(objectId);
                    continue;
                }
                movedFiles.add(objectId);
            }
            results.put("moved-folders", movedFolders);
            results.put("moved-files", movedFiles);
        }
        return results;
    }

    @Callable
    public Map<String, Object> renameFolder(String id, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JCRResourcesCollection folder = (JCRResourcesCollection)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Edit", (Object)folder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to edit folder without convenient right [Plugin_Explorer_Folder_Edit]");
        }
        LinkedList<String> errors = new LinkedList<String>();
        JCRResourcesCollection newFolder = null;
        try {
            newFolder = (JCRResourcesCollection)this.renameObject((JCRAmetysObject)folder, name, errors);
            if (!errors.isEmpty()) {
                result.put("success", false);
                result.put("message", errors.get(0));
            } else {
                newFolder.saveChanges();
                result.put("success", true);
                result.putAll(this._extractFolderData((ResourceCollection)newFolder));
            }
        }
        catch (RepositoryException e) {
            this.getLogger().error("Repository exception during folder edition.", (Throwable)e);
            errors.add("repository");
        }
        return result;
    }

    @Callable
    public Map<String, Object> editFolder(String id, String inputName, String description) {
        JCRResourcesCollection folder = (JCRResourcesCollection)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Edit", (Object)folder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to edit folder without convenient right [Plugin_Explorer_Folder_Edit]");
        }
        LinkedList<String> errors = new LinkedList<String>();
        JCRResourcesCollection newFolder = null;
        boolean success = true;
        try {
            newFolder = StringUtils.isBlank((CharSequence)inputName) || folder.getName().equals(inputName) ? folder : (JCRResourcesCollection)this.renameObject((JCRAmetysObject)folder, inputName, errors);
        }
        catch (RepositoryException e) {
            success = false;
            this.getLogger().error("Repository exception during folder edition.", (Throwable)e);
            errors.add("repository");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            if (!"already-exist".equals(error)) {
                success = false;
                result.put("message", error);
            } else {
                newFolder = folder;
            }
        }
        if (success && newFolder != null) {
            if (StringUtils.isNotBlank((CharSequence)description) && !StringUtils.equals((CharSequence)newFolder.getDescription(), (CharSequence)description)) {
                newFolder.setDescription(description);
            }
            newFolder.saveChanges();
            result.putAll(this._extractFolderData((ResourceCollection)newFolder));
        }
        result.put("success", success);
        return result;
    }

    @Callable
    public Map<String, Object> deleteFolder(String id) {
        ResourceCollection rootCollection;
        boolean isRoot;
        RemovableAmetysObject folder = (RemovableAmetysObject)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_Folder_Delete", (Object)folder) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to delete folder without convenient right [Plugin_Explorer_Folder_Delete]");
        }
        LinkedList errors = new LinkedList();
        String parentId = this.deleteObject(folder, errors);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
        }
        boolean bl = isRoot = (rootCollection = this._getRootFromRequest()) != null && rootCollection.getId().equals(parentId);
        if (StringUtils.isNotEmpty((CharSequence)parentId) && !isRoot) {
            result.put("parentId", parentId);
        }
        return result;
    }

    @Callable
    public Map<String, Object> lockResources(List<String> ids) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("locked-resources", new ArrayList());
        result.put("unlocked-resources", new ArrayList());
        for (String id : ids) {
            JCRResource resource = (JCRResource)this._resolver.resolveById(id);
            if (!resource.isLocked()) {
                resource.lock();
                List lockedResources = (List)result.get("locked-resources");
                lockedResources.add(id);
                continue;
            }
            if (resource.getLockOwner().equals((Object)this._currentUserProvider.getUser())) continue;
            UserIdentity lockOwner = resource.getLockOwner();
            this.getLogger().error("Unable to lock resource of id '" + id + "': the resource is already locked by user " + UserIdentity.userIdentityToString((UserIdentity)lockOwner));
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("id", id);
            info.put("name", resource.getName());
            info.put("lockOwner", this._userHelper.user2json(lockOwner));
            List unlockedResources = (List)result.get("unlocked-resources");
            unlockedResources.add(info);
        }
        return result;
    }

    @Callable
    public Map<String, Object> unlockResources(List<String> ids) {
        UserIdentity currentUser = this._currentUserProvider.getUser();
        boolean canUnlockAll = this._rightManager.hasRight(currentUser, "Plugin_Explorer_File_Unlock_All", (Object)"/cms") == RightManager.RightResult.RIGHT_ALLOW;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("unlocked-resources", new ArrayList());
        result.put("still-locked-resources", new ArrayList());
        for (String id : ids) {
            List unlockedResources;
            JCRResource resource = (JCRResource)this._resolver.resolveById(id);
            if (resource.isLocked()) {
                if (canUnlockAll || resource.getLockOwner().equals((Object)currentUser)) {
                    resource.unlock();
                    unlockedResources = (List)result.get("unlocked-resources");
                    unlockedResources.add(id);
                    continue;
                }
                UserIdentity lockOwner = resource.getLockOwner();
                this.getLogger().error("Unable to unlock resource of id '" + id + "': the resource is locked by user " + UserIdentity.userIdentityToString((UserIdentity)lockOwner));
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("id", id);
                info.put("name", resource.getName());
                info.put("lockOwner", this._userHelper.user2json(lockOwner));
                List stilllockedResources = (List)result.get("still-locked-resources");
                stilllockedResources.add(info);
                continue;
            }
            unlockedResources = (List)result.get("unlocked-resources");
            unlockedResources.add(id);
        }
        return result;
    }

    @Callable
    public boolean resourceExists(String parentId, String name) {
        ResourceCollection folder = this._getRootIfNull(parentId);
        return folder != null && this.resourceExists((TraversableAmetysObject)folder, name);
    }

    @Callable
    public Map<String, Object> renameFile(String id, String name) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JCRResource file = (JCRResource)this._resolver.resolveById(id);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Rename", (Object)file) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to rename file without convenient right [Plugin_Explorer_File_Rename]");
        }
        if (StringUtils.isNotEmpty((CharSequence)name) && !StringUtils.equals((CharSequence)file.getName(), (CharSequence)name)) {
            LinkedList<String> errors = new LinkedList<String>();
            JCRResource renamedFile = null;
            try {
                renamedFile = this.renameResource(file, name, errors);
                if (!errors.isEmpty()) {
                    result.put("success", false);
                    result.put("message", errors.get(0));
                } else {
                    renamedFile.saveChanges();
                    result.put("success", true);
                    result.putAll(this._extractFileData((Resource)renamedFile));
                }
            }
            catch (RepositoryException e) {
                this.getLogger().error("Repository exception during file edition.", (Throwable)e);
                errors.add("repository");
            }
        }
        return result;
    }

    @Callable
    public Map<String, Object> editFile(String id, String inputName, String description, Collection<String> tags) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JCRResource file = (JCRResource)this._resolver.resolveById(id);
        if (!this.checkLock((AmetysObject)file)) {
            this.getLogger().warn("User '{}' is trying to edit file '{}' but it is locked by another user", (Object)this._currentUserProvider.getUser(), (Object)file.getName());
            result.put("message", "locked");
            return result;
        }
        LinkedList<String> errors = new LinkedList<String>();
        JCRResource renamedFile = null;
        if (StringUtils.isNotEmpty((CharSequence)inputName) && !StringUtils.equals((CharSequence)file.getName(), (CharSequence)inputName)) {
            if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Rename", (Object)file) != RightManager.RightResult.RIGHT_ALLOW) {
                throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to rename file without convenient right [Plugin_Explorer_File_Rename]");
            }
            try {
                renamedFile = this.renameResource(file, inputName, errors);
                if (errors.isEmpty()) {
                    file = renamedFile;
                }
            }
            catch (RepositoryException e) {
                this.getLogger().error("Repository exception during folder edition.", (Throwable)e);
                errors.add("repository-rename");
            }
        }
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
            return result;
        }
        List<String> fileTags = this._sanitizeFileTags(tags);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Edit_DC_Metadata", (Object)file) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to edit dc for file without convenient right [Plugin_Explorer_File_Edit_DC_Metadata]");
        }
        HashMap<String, CharSequence> editValues = new HashMap<String, CharSequence>();
        editValues.put("dc_description", StringUtils.defaultIfEmpty((CharSequence)description, null));
        try {
            file.setKeywords(fileTags.toArray(new String[fileTags.size()]));
            this.setDCMetadata((ModifiableResource)file, editValues);
            this._projectManager.addTags(fileTags);
            file.saveChanges();
        }
        catch (AmetysRepositoryException e) {
            this.getLogger().error("Repository exception during folder edition.", (Throwable)e);
            errors.add("repository-edit");
        }
        if (!errors.isEmpty()) {
            String error = (String)errors.get(0);
            result.put("message", error);
        } else {
            result.putAll(this._extractFileData((Resource)file));
        }
        return result;
    }

    @Callable
    public Map<String, Object> setTags(String resourceId, List<Object> tags) {
        JCRResource file = (JCRResource)this._resolver.resolveById(resourceId);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Edit_DC_Metadata", (Object)file) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new AccessDeniedException("User '" + this._currentUserProvider.getUser() + "' tried to tag file without convenient right [Plugin_Explorer_File_Edit_DC_Metadata]");
        }
        List<Map<String, Object>> createdTagsJson = this._workspaceHelper.handleTags((TaggableAmetysObject)file, tags);
        file.saveChanges();
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("fileTags", this._tags2json((Resource)file));
        results.put("newTags", createdTagsJson);
        return results;
    }

    @Callable
    public Map<String, Object> copyFiles(List<String> ids, String targetId) throws RepositoryException {
        ResourceCollection folder = this._getRootIfNull(targetId);
        if (folder == null) {
            throw new IllegalArgumentException("Unable to copy files: parent folder not found");
        }
        if (!(folder instanceof ModifiableResourceCollection)) {
            throw new IllegalClassException(ModifiableResourceCollection.class, folder.getClass());
        }
        return this.copyResource(ids, (ModifiableResourceCollection)folder);
    }

    @Callable
    public Map<String, Object> moveDocuments(List<String> ids, String targetId) throws RepositoryException {
        ResourceCollection folder = this._getRootIfNull(targetId);
        if (folder == null) {
            throw new IllegalArgumentException("Unable to move documents: parent folder not found");
        }
        if (!(folder instanceof JCRTraversableAmetysObject)) {
            throw new IllegalClassException(JCRTraversableAmetysObject.class, folder.getClass());
        }
        return this.moveObject(ids, (JCRTraversableAmetysObject)folder);
    }

    @Callable
    public Map<String, Object> searchFiles(String query, String lang) throws Exception {
        MatchAllQuery solrQuery;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String escapedQuery = query.replace("\"", "\\\"");
        if (StringUtils.isEmpty((CharSequence)query)) {
            solrQuery = new MatchAllQuery();
        } else {
            ArrayList<Object> queries = new ArrayList<Object>();
            queries.add(new FilenameQuery(query));
            queries.add(new StringQuery("title", Query.Operator.LIKE, "*" + query + "*", null));
            queries.add(new FullTextQuery(escapedQuery, lang));
            queries.add(new KeywordQuery(escapedQuery.split(" ")));
            solrQuery = new OrQuery(queries);
        }
        AmetysObjectIterable results = this._searcherFactory.create().withQuery((Query)solrQuery).addFilterQuery((Query)new DocumentTypeQuery("projectResource")).addFilterQuery((Query)new ProjectQuery(this._getProjectFromRequest().getId())).search();
        List resourceData = results.stream().map(this::_extractFileData).collect(Collectors.toList());
        result.put("resources", resourceData);
        return result;
    }

    @Callable
    public Map<String, Object> searchFilesByType(String type) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        AmetysObjectIterable results = this._searcherFactory.create().withQuery((Query)new MimeTypeGroupQuery(type)).addFilterQuery((Query)new DocumentTypeQuery("projectResource")).addFilterQuery((Query)new ProjectQuery(this._getProjectFromRequest().getId())).search();
        List resourceData = results.stream().map(this::_extractFileData).collect(Collectors.toList());
        result.put("resources", resourceData);
        return result;
    }

    @Callable
    public Map<String, Object> getRootFolder() {
        return this.getFolder(null);
    }

    @Callable
    public Map<String, Object> getFolder(String folderId) {
        ResourceCollection collection = this._getRootIfNull(folderId);
        return this._extractFolderData(collection);
    }

    @Callable
    public Map<String, Object> getFile(String resourceId) {
        Resource resource = (Resource)this._resolver.resolveById(resourceId);
        return this._extractFileData(resource);
    }

    @Callable
    public List<Map<String, Object>> getFolders(String parentId) {
        return this.getChildDocumentsData(parentId, false, true);
    }

    @Callable
    public List<Map<String, Object>> getFiles(String parentId) {
        return this.getChildDocumentsData(parentId, true, false);
    }

    @Callable
    public Map<String, Object> getFileParentInfo(String fileId) {
        try {
            Resource file = (Resource)this._resolver.resolveById(fileId);
            AmetysObject parent = file.getParent();
            String parentId = parent != null && parent instanceof ResourceCollection ? parent.getId() : null;
            return this.getFoldersAndFiles(parentId);
        }
        catch (AmetysRepositoryException e) {
            return Map.of("error", "invalid-item-id");
        }
    }

    @Callable
    public Map<String, Object> getFoldersAndFiles(String folderId) {
        ResourceCollection root = this._getRootFromRequest();
        ResourceCollection collection = StringUtils.isNotEmpty((CharSequence)folderId) ? (ResourceCollection)this._resolver.resolveById(folderId) : root;
        Map<String, Object> data = this._extractFolderData(collection);
        data.put("root", collection.getId().equals(root.getId()));
        data.put("files", this.getChildDocumentsData(folderId, true, false));
        data.put("children", this.getChildDocumentsData(folderId, false, true));
        return data;
    }

    @Callable
    public List<Map<String, Object>> getChildDocumentsData(String parentId, boolean excludeFolders, boolean excludeFiles) {
        ResourceCollection document = this._getRootIfNull(parentId);
        if (document == null) {
            throw new IllegalArgumentException("Unable to get child documents: parent folder not found");
        }
        return this.getChildDocumentsData(document, excludeFolders, excludeFiles);
    }

    public List<Map<String, Object>> getChildDocumentsData(ResourceCollection document, boolean excludeFolders, boolean excludeFiles) {
        ResourceCollection parent = this._getRootIfNull(document);
        if (parent == null) {
            throw new IllegalArgumentException("Unable to get child documents: parent folder not found");
        }
        return parent.getChildren().stream().map(child -> this._extractDocumentData((AmetysObject)child, excludeFolders, excludeFiles)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Deprecated
    @Callable
    public Map<String, Object> getDocumentData(String id, boolean excludeFilesInFolderHierarchy) {
        ResourceCollection document;
        Object object = document = id == null ? this._getRootFromRequest() : this._resolver.resolveById(id);
        if (document == null) {
            throw new IllegalArgumentException("No project found in request to get root document data");
        }
        HashMap data = this._extractDocumentData((AmetysObject)document, false, false);
        return data != null ? data : new HashMap();
    }

    @Callable
    public List<Map<String, Object>> getDocumentsData(List<String> ids, boolean excludeFilesInFolderHierarchy) {
        return ids.stream().map(id -> this.getDocumentData((String)id, excludeFilesInFolderHierarchy)).collect(Collectors.toList());
    }

    @Callable
    public String generateWebdavUri(String documentId) {
        return ResolveURIComponent.resolve((String)"webdav-project-resource", (String)documentId, (boolean)false, (boolean)true);
    }

    private ResourceCollection _getRootIfNull(ResourceCollection document) {
        return document != null ? document : this._getRootFromRequest();
    }

    private ResourceCollection _getRootIfNull(String documentId) {
        return StringUtils.isNotEmpty((CharSequence)documentId) ? (ResourceCollection)this._resolver.resolveById(documentId) : this._getRootFromRequest();
    }

    private ResourceCollection _getRootFromRequest() {
        Project project = this._getProjectFromRequest();
        if (project != null) {
            return this._getRootFromProject(project);
        }
        return null;
    }

    private ResourceCollection _getRootFromObject(AmetysObject ametysObject) {
        Project project = this._getProjectFomObject(ametysObject);
        if (project != null) {
            return this._getRootFromProject(project);
        }
        return null;
    }

    private ResourceCollection _getRootFromProject(Project project) {
        if (project != null) {
            DocumentWorkspaceModule module = (DocumentWorkspaceModule)this._moduleEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID);
            return module.getModuleRoot(project, false);
        }
        return null;
    }

    private Project _getProjectFromRequest() {
        Request request = ContextHelper.getRequest((Context)this._context);
        String projectName = (String)request.getAttribute("projectName");
        if (projectName != null) {
            return this._projectManager.getProject(projectName);
        }
        return null;
    }

    private Project _getProjectFomObject(AmetysObject ametysObject) {
        AmetysObject parent;
        for (parent = ametysObject; parent != null && !(parent instanceof Project); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        return (Project)parent;
    }

    private String _getCurrentLanguage() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return (String)request.getAttribute("sitemapLanguage");
    }

    protected Map<String, Object> _extractDocumentData(AmetysObject document, boolean excludeFolders, boolean excludeFiles) {
        ResourceCollection folder;
        if (!excludeFiles && document instanceof Resource) {
            Resource file = (Resource)document;
            if (this._canView(file)) {
                return this._extractFileData(file);
            }
        } else if (!excludeFolders && document instanceof ResourceCollection && this._canView(folder = (ResourceCollection)document)) {
            return this._extractFolderData(folder);
        }
        return null;
    }

    protected Map<String, Object> _extractFolderData(ResourceCollection folder) {
        boolean hasChildren;
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", folder.getId());
        data.put("name", folder.getName());
        data.put("path", this._getFolderPath(folder));
        data.put("type", ResourceType.FOLDER.name().toLowerCase());
        data.put("description", StringUtils.defaultString((String)folder.getDescription()));
        AmetysObject parent = folder.getParent();
        if (parent != null && parent instanceof ResourceCollection) {
            data.put("location", ((ResourceCollection)parent).getName());
            data.put("parentId", parent.getId());
        }
        if (hasChildren = this._hasChildren(folder, true)) {
            data.put("children", Collections.EMPTY_LIST);
        }
        data.put("modifiable", folder instanceof ModifiableAmetysObject);
        data.put("canCreateChild", folder instanceof ModifiableExplorerNode);
        data.put("rights", this._extractFolderRightData(folder));
        data.put("notification", false);
        return data;
    }

    private List<String> _getFolderPath(ResourceCollection folder) {
        ArrayList<String> paths = new ArrayList<String>();
        ResourceCollection rootDocuments = this._getRootFromObject((AmetysObject)folder);
        if (!rootDocuments.equals(folder)) {
            ArrayList<Object> parents = new ArrayList<Object>();
            AmetysObject parent = folder.getParent();
            while (parent instanceof ExplorerNode && !parent.equals((Object)rootDocuments)) {
                parents.add((ExplorerNode)parent);
                parent = parent.getParent();
            }
            parents.add(rootDocuments);
            Collections.reverse(parents);
            parents.stream().forEach(p -> paths.add(p.getId()));
        }
        return paths;
    }

    protected boolean _hasChildren(ResourceCollection folder, boolean ignoreFiles) {
        try (AmetysObjectIterable children = folder.getChildren();){
            for (AmetysObject child : children) {
                if ((!(child instanceof ResourceCollection) || !this._canView((ResourceCollection)child)) && (ignoreFiles || !(child instanceof Resource) || !this._canView((Resource)child))) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    protected Map<String, Object> _extractFolderRightData(ResourceCollection folder) {
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        rightsData.put("add-file", this._rightManager.hasRight(user, "Plugin_Explorer_File_Add", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("add-folder", this._rightManager.hasRight(user, "Plugin_Explorer_Folder_Add", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("add-cmis-folder", this._rightManager.hasRight(user, "Plugin_Explorer_CMIS_Add", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("edit", this._rightManager.hasRight(user, "Plugin_Explorer_Folder_Edit", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete", this._rightManager.hasRight(user, "Plugin_Explorer_Folder_Delete", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        return rightsData;
    }

    @Callable
    public Map<String, Object> addFile(Part part, String parentId, boolean unarchive, boolean allowRename, boolean allowUpdate) {
        ModifiableResourceCollection modifiableFolder = this.getModifiableResourceCollection(parentId);
        this._addOrUpdateResourceHelper.checkAddResourceRight(modifiableFolder);
        AddOrUpdateResourceHelper.ResourceOperationMode mode = this.getOperationMode(unarchive, allowRename, allowUpdate);
        AddOrUpdateResourceHelper.ResourceOperationResult operationResult = this._addOrUpdateResourceHelper.performResourceOperation(part, modifiableFolder, mode);
        return this.generateActionResult((ResourceCollection)modifiableFolder, operationResult);
    }

    public Map<String, Object> addFile(InputStream inputStream, String fileName, String parentId, boolean unarchive, boolean allowRename, boolean allowUpdate) {
        ModifiableResourceCollection modifiableFolder = this.getModifiableResourceCollection(parentId);
        AddOrUpdateResourceHelper.ResourceOperationMode mode = this.getOperationMode(unarchive, allowRename, allowUpdate);
        AddOrUpdateResourceHelper.ResourceOperationResult operationResult = this._addOrUpdateResourceHelper.performResourceOperation(inputStream, fileName, modifiableFolder, mode);
        return this.generateActionResult((ResourceCollection)modifiableFolder, operationResult);
    }

    private ModifiableResourceCollection getModifiableResourceCollection(String ametysId) {
        ResourceCollection folder = this._getRootIfNull(ametysId);
        if (folder == null) {
            throw new IllegalArgumentException("Root folder not found");
        }
        if (!(folder instanceof ModifiableResourceCollection)) {
            throw new IllegalClassException(ModifiableResourceCollection.class, folder.getClass());
        }
        return (ModifiableResourceCollection)folder;
    }

    private AddOrUpdateResourceHelper.ResourceOperationMode getOperationMode(boolean unarchive, boolean allowRename, boolean allowUpdate) {
        AddOrUpdateResourceHelper.ResourceOperationMode mode = AddOrUpdateResourceHelper.ResourceOperationMode.ADD;
        if (unarchive) {
            mode = AddOrUpdateResourceHelper.ResourceOperationMode.ADD_UNZIP;
        } else if (allowRename) {
            mode = AddOrUpdateResourceHelper.ResourceOperationMode.ADD_RENAME;
        } else if (allowUpdate) {
            mode = AddOrUpdateResourceHelper.ResourceOperationMode.UPDATE;
        }
        return mode;
    }

    private Map<String, Object> generateActionResult(ResourceCollection folder, AddOrUpdateResourceHelper.ResourceOperationResult operationResult) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (operationResult.isSuccess()) {
            List resourceData = operationResult.getResources().stream().filter(r -> r.getParent().equals((Object)folder)).map(this::_extractFileData).collect(Collectors.toList());
            result.put("resources", resourceData);
            result.put("unzip", operationResult.isUnzip());
        } else {
            result.put("message", operationResult.getErrorMessage());
        }
        return result;
    }

    protected Map<String, Object> _extractFileData(Resource file) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("id", file.getId());
        data.put("name", file.getName());
        data.put("path", this._getFilePath(file));
        String resourcePath = file.getResourcePath();
        int i = resourcePath.lastIndexOf(".");
        resourcePath = i != -1 ? resourcePath.substring(0, i) : resourcePath;
        String encodedPath = FilenameUtils.encodePath((String)resourcePath);
        data.put("encodedPath", URIUtils.encodeURI((String)encodedPath, Map.of()));
        data.put("type", ResourceType.FILE.name().toLowerCase());
        data.put("fileType", this._workspaceHelper.getFileType(file).name().toLowerCase());
        data.put("fileExtension", StringUtils.substringAfterLast((String)file.getName(), (String)"."));
        AmetysObject parent = file.getParent();
        if (parent != null && parent instanceof ResourceCollection) {
            data.put("location", ((ResourceCollection)parent).getName());
            data.put("parentId", parent.getId());
            data.put("parentPath", ((ResourceCollection)parent).getExplorerPath());
        }
        data.put("modifiable", file instanceof ModifiableResource);
        data.put("canCreateChild", file instanceof ModifiableExplorerNode);
        data.put("description", file.getDCDescription());
        data.put("tags", this._tags2json(file));
        data.put("mimetype", file.getMimeType());
        data.put("length", String.valueOf(file.getLength()));
        boolean image = this._workspaceHelper.isImage(file);
        if (image) {
            data.put("image", true);
        }
        data.put("hasOnlyOfficePreview", this._onlyOfficeManager.canBePreviewed(file.getId()));
        UserIdentity creatorIdentity = file.getCreator();
        data.put("creator", this._userHelper.user2json(creatorIdentity));
        data.put("creationDate", DateUtils.dateToString((Date)file.getCreationDate()));
        UserIdentity contribIdentity = file.getLastContributor();
        data.put("author", this._userHelper.user2json(contribIdentity));
        data.put("lastModified", DateUtils.dateToString((Date)file.getLastModified()));
        data.put("rights", this._extractFileRightData(file));
        data.putAll(this._extractFileLockData(file));
        return data;
    }

    private List<Map<String, Object>> _tags2json(Resource file) {
        return ((TagAwareAmetysObject)file).getTags().stream().filter(tag -> this._tagProviderExtensionPoint.hasTag((String)tag, Map.of())).map(tag -> (DefaultTag)this._tagProviderExtensionPoint.getTag((String)tag, Map.of())).map(this::_tag2json).collect(Collectors.toList());
    }

    private Map<String, Object> _tag2json(Tag tag) {
        HashMap<String, Object> tagMap = new HashMap<String, Object>();
        tagMap.put("text", tag.getTitle());
        tagMap.put("name", tag.getName());
        tagMap.put("color", null);
        return tagMap;
    }

    private List<String> _getFilePath(Resource file) {
        return this._getFolderPath((ResourceCollection)file.getParent());
    }

    protected Map<String, Object> _extractFileRightData(Resource file) {
        ResourceCollection folder;
        HashMap<String, Object> rightsData = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        rightsData.put("rename", this._rightManager.hasRight(user, "Plugin_Explorer_File_Rename", (Object)(folder = (ResourceCollection)file.getParent())) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("edit", this._rightManager.hasRight(user, "Plugin_Explorer_File_Edit_DC_Metadata", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("delete", this._rightManager.hasRight(user, "Plugin_Explorer_File_Delete", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("unlock", this._rightManager.hasRight(user, "Plugin_Explorer_File_Unlock_All", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("comment", this._rightManager.hasRight(user, "Plugin_Explorer_File_Comment", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        rightsData.put("moderate-comments", this._rightManager.hasRight(user, "Plugin_Explorer_File_Moderate_Comments", (Object)folder) == RightManager.RightResult.RIGHT_ALLOW);
        return rightsData;
    }

    protected Map<String, Object> _extractFileLockData(Resource file) {
        HashMap<String, Object> lockData = new HashMap<String, Object>();
        if (file instanceof LockableAmetysObject) {
            boolean isLocked = ((LockableAmetysObject)file).isLocked();
            lockData.put("locked", isLocked);
            if (isLocked) {
                UserIdentity lockOwner = ((LockableAmetysObject)file).getLockOwner();
                lockData.put("isLockOwner", lockOwner.equals((Object)this._currentUserProvider.getUser()));
                lockData.put("lockOwner", this._userHelper.user2json(lockOwner));
            }
        }
        return lockData;
    }

    private List<String> _sanitizeFileTags(Collection<String> tags) throws AmetysRepositoryException {
        return Optional.ofNullable(tags).orElseGet(ArrayList::new).stream().map(String::trim).map(String::toLowerCase).distinct().collect(Collectors.toList());
    }

    protected void _setComment(JCRPost comment, String content) {
        try {
            this._htmlTransformer.transform(content, comment.getContent());
        }
        catch (IOException e) {
            throw new AmetysRepositoryException("Failed to transform comment into rich text", (Throwable)e);
        }
    }

    protected String _getComment(JCRPost post) throws AmetysRepositoryException {
        String string;
        Source contentSource = null;
        try {
            HashMap<String, InputStream> parameters = new HashMap<String, InputStream>();
            parameters.put("source", post.getContent().getInputStream());
            contentSource = this._sourceResolver.resolveURI("cocoon://_plugins/" + this._pluginName + "/convert/html2html", null, parameters);
            string = IOUtils.toString((InputStream)contentSource.getInputStream(), (String)"UTF-8");
        }
        catch (IOException e) {
            try {
                throw new AmetysRepositoryException("Failed to transform rich text into string", (Throwable)e);
            }
            catch (Throwable throwable) {
                this._sourceResolver.release(contentSource);
                throw throwable;
            }
        }
        this._sourceResolver.release(contentSource);
        return string;
    }

    protected String _getCommentForEditing(JCRPost post) throws AmetysRepositoryException {
        try {
            StringBuilder sb = new StringBuilder();
            this._htmlTransformer.transformForEditing(post.getContent(), sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AmetysRepositoryException("Failed to transform rich text into string", (Throwable)e);
        }
    }

    protected boolean _canView(ResourceCollection folder) {
        return this._rightManager.currentUserHasReadAccess((Object)folder);
    }

    protected boolean _canView(Resource file) {
        return this._rightManager.currentUserHasReadAccess((Object)file.getParent());
    }

    @Callable
    public Map<String, String> getCMISProperties(String id) {
        return super.getCMISProperties(id);
    }

    @Callable
    public Map<String, Object> addCMISCollection(String parentId, String originalName, String url, String login, String password, String repoId, String mountPoint, boolean renameIfExists) {
        String rootId;
        String string = rootId = parentId == null ? this._getRootFromRequest().getId() : parentId;
        if (rootId == null) {
            throw new IllegalArgumentException("Unable to add CMIS collection: parent folder not found.");
        }
        return super.addCMISCollection(rootId, originalName, url, login, password, repoId, mountPoint, renameIfExists);
    }

    @Callable
    public Map<String, Object> editCMISCollection(String id, String name, String url, String login, String password, String repoId, String mountPoint) throws RepositoryException {
        LinkedList<String> errors = new LinkedList<String>();
        try {
            this.renameObject(id, name);
        }
        catch (RepositoryException e) {
            this.getLogger().error("Repository exception during CMIS folder edition.", (Throwable)e);
            errors.add("repository");
        }
        Map result = super.editCMISCollection(id, url, login, password, repoId, mountPoint);
        if (errors.size() > 0) {
            result.put("errors", errors);
        }
        return result;
    }

    @Callable
    public boolean isCMISCollection(String id) {
        return super.isCMISCollection(id);
    }

    public Long getDocumentsCount(Project project) {
        Function<Project, ResourceCollection> getModuleRoot = proj -> this._moduleEP.getModule(DocumentWorkspaceModule.DOCUMENT_MODULE_ID).getModuleRoot((Project)((Object)proj), false);
        return Optional.ofNullable(project).map(getModuleRoot).map(root -> this._getChildDocumentsCount((ResourceCollection)root)).orElse(null);
    }

    private Long _getChildDocumentsCount(ResourceCollection collection) {
        return collection.getChildren().stream().map(ao -> ao instanceof Resource ? 1L : (ao instanceof ResourceCollection ? this._getChildDocumentsCount((ResourceCollection)ao) : 0L)).reduce(0L, Long::sum);
    }

    @Callable
    public Map<String, Object> createFile(String folderId, String type) throws Exception {
        OfficeType officeType = OfficeType.valueOf(type.toUpperCase());
        String lang = this._getCurrentLanguage();
        SpreadsheetMLPackage opcPackage = null;
        String name = null;
        String title = null;
        switch (officeType) {
            case EXCEL: {
                opcPackage = SpreadsheetMLPackage.createPackage();
                opcPackage.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_EXCEL_NEW_FILE_PART1_TITLE"), lang), 1L);
                name = "newExcel.xlsx";
                title = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_EXCEL_NEW_FILE_TITLE"), lang) + ".xlsx";
                break;
            }
            case WORD: {
                opcPackage = WordprocessingMLPackage.createPackage();
                name = "newWord.docx";
                title = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_WORD_NEW_FILE_TITLE"), lang) + ".docx";
                break;
            }
            case POWERPOINT: {
                opcPackage = PresentationMLPackage.createPackage();
                name = "newPowerPoint.pptx";
                title = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_FILE_MANAGER_ONLYOFFICE_POWERPOINT_NEW_FILE_TITLE"), lang) + ".pptx";
                break;
            }
            default: {
                throw new IllegalArgumentException("Can create new file with unknown type '" + type + "'");
            }
        }
        File file = new File(AmetysHomeHelper.getAmetysHomeData(), name);
        opcPackage.save(file);
        try (FileInputStream is = new FileInputStream(file);){
            String uniqueTitle = this._getUniqueTitle(folderId, title);
            Map<String, Object> response = this.addFile(is, uniqueTitle, folderId, false, false, false);
            FileUtils.forceDelete((File)file);
            Map<String, Object> map = response;
            return map;
        }
    }

    private String _getUniqueTitle(String folderId, String title) throws RepositoryException {
        JCRAmetysObject folder = (JCRAmetysObject)this._resolver.resolveById(folderId);
        String ext = StringUtils.substringAfterLast((String)title, (String)".");
        String name = StringUtils.substringBeforeLast((String)title, (String)".");
        Object newTitle = title;
        int count = 1;
        Node node = folder.getNode();
        while (node.hasNode((String)newTitle)) {
            newTitle = name + " (" + count + ")." + ext;
            ++count;
        }
        return newTitle;
    }

    protected Map<String, Object> _comment2json(JCRPost comment, boolean isEdition) {
        Map comment2json = super._comment2json(comment, isEdition);
        String lang = this._getCurrentLanguage();
        String authorImgUrl = this._workspaceHelper.getAvatar(comment.getAuthor(), lang, 30);
        Map author = (Map)comment2json.get("author");
        UserIdentity authorIdentity = comment.getAuthor();
        User user = this._userManager.getUser(authorIdentity);
        if (user != null) {
            author.put("name", author.get("fullname"));
            author.put("avatar", authorImgUrl);
            author.put("id", UserIdentity.userIdentityToString((UserIdentity)authorIdentity));
            Content member = this._projectMemberManager.getUserContent(lang, user);
            if (member != null) {
                if (member.hasValue("function")) {
                    author.put("function", member.getValue("function"));
                }
                if (member.hasValue("organisation-accronym")) {
                    author.put("organisationAcronym", member.getValue("organisation-accronym"));
                }
            }
        }
        comment2json.put("text", isEdition ? this._getCommentForEditing(comment) : this._getComment(comment));
        return comment2json;
    }

    public static enum ResourceType {
        FOLDER,
        FILE;

    }

    public static enum OfficeType {
        WORD,
        EXCEL,
        POWERPOINT;

    }
}

