/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.onlyoffice;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.documents.WorkspaceExplorerResourceDAO;
import org.ametys.plugins.workspaces.documents.onlyoffice.OnlyOfficeKeyManager;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOnlyOfficeResponse
extends ServiceableAction
implements ThreadSafe {
    protected Logger _logger = LoggerFactory.getLogger((String)GetOnlyOfficeResponse.class.getName());
    protected JSONUtils _jsonUtils;
    protected AmetysObjectResolver _resolver;
    protected WorkspaceExplorerResourceDAO _workspaceExplorerResourceDAO;
    protected OnlyOfficeKeyManager _onlyOfficeManager;
    protected CurrentUserProvider _currentUserProvider;
    protected RightManager _rightManager;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._workspaceExplorerResourceDAO = (WorkspaceExplorerResourceDAO)((Object)smanager.lookup(WorkspaceExplorerResourceDAO.ROLE));
        this._onlyOfficeManager = (OnlyOfficeKeyManager)((Object)smanager.lookup(OnlyOfficeKeyManager.ROLE));
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)smanager.lookup(RightManager.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        String resourceId = request.getParameter("id");
        HttpServletRequest httpRequest = (HttpServletRequest)objectModel.get("httprequest");
        try (ServletInputStream is = httpRequest.getInputStream();){
            String body = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            Map jsonMap = this._jsonUtils.convertJsonToMap(body);
            boolean success = this.callbackHandler(jsonMap, resourceId);
            result.put("error", success ? 0 : 1);
        }
        request.setAttribute(JSonReader.OBJECT_TO_READ, result);
        return EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean callbackHandler(Map<String, Object> response, String resourceId) {
        String key = (String)response.get("key");
        if (key == null) {
            this._logger.error("The edited document identifier is missing in document editing service's response");
            return false;
        }
        Object oStatus = response.get("status");
        if (oStatus == null) {
            this._logger.error("The status of the edited document is missing in document editing service's response");
            return false;
        }
        int status = (Integer)oStatus;
        this._logger.debug("Receive status {} for key '{}' and resource '{}' from document editing service", new Object[]{status, key, resourceId});
        switch (status) {
            case 0: {
                return true;
            }
            case 1: {
                return this.getUserConnectionStatus(response) != UserStatus.UNKNOWN;
            }
            case 2: {
                try {
                    Boolean notModified = (Boolean)response.get("notmodified");
                    if (notModified == null || !notModified.booleanValue()) {
                        boolean bl = this.saveDocument(response, resourceId);
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                finally {
                    this._onlyOfficeManager.removeKey(resourceId);
                }
            }
            case 3: {
                this._logger.error("Document editing service returned that document saving error has occurred (3)");
                this._onlyOfficeManager.removeKey(resourceId);
                return false;
            }
            case 4: {
                this._logger.info("Document editing service returned that document was closed with no changes (4)");
                this._onlyOfficeManager.removeKey(resourceId);
                return this.getUserConnectionStatus(response) != UserStatus.UNKNOWN;
            }
            case 6: {
                return this.saveDocument(response, resourceId);
            }
            case 7: {
                this._logger.error("Document editing service returned that an error has occurred while force saving the document (7)");
                return false;
            }
        }
        this._logger.error("Document editing service returned an invalid status: " + status);
        return false;
    }

    protected UserStatus getUserConnectionStatus(Map<String, Object> response) {
        List actions;
        Iterator iterator;
        if (response != null && response.containsKey("actions") && (iterator = (actions = (List)response.get("actions")).iterator()).hasNext()) {
            Map action = (Map)iterator.next();
            int type = (Integer)action.get("type");
            return type == 1 ? UserStatus.CONNECTION : UserStatus.DISCONNECTION;
        }
        return UserStatus.UNKNOWN;
    }

    protected boolean saveDocument(Map<String, Object> response, String resourceId) {
        if (response.get("notmodified") != null && ((Boolean)response.get("notmodified")).booleanValue()) {
            this._logger.debug("No modification was detected by document editing service");
            return true;
        }
        String url = (String)response.get("url");
        if (StringUtils.isEmpty((CharSequence)url)) {
            this._logger.error("Unable to save document, the document url is missing");
            return false;
        }
        return this.processSave(url, resourceId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean processSave(String documentURI, String resourceId) {
        try {
            URL url = new URL(documentURI);
            Resource resource = (Resource)this._resolver.resolveById(resourceId);
            if (this._rightManager.hasRight(this._currentUserProvider.getUser(), "Plugin_Explorer_File_Add", (Object)resource.getParent()) != RightManager.RightResult.RIGHT_ALLOW) {
                this._logger.error("User '" + this._currentUserProvider.getUser() + "' tried to add file without convenient right [Plugin_Explorer_File_Add]");
                return false;
            }
            try (InputStream is = url.openStream();){
                Map<String, Object> result = this._workspaceExplorerResourceDAO.addFile(is, resource.getName(), resource.getParent().getId(), false, false, true);
                if (result != null && result.containsKey("resources")) {
                    boolean bl2 = true;
                    return bl2;
                }
                this._logger.error("Failed to update document with id '{}", (Object)resourceId);
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            this._logger.error("Unable to get document at uri {}", (Object)documentURI, (Object)e);
            return false;
        }
    }

    public static enum UserStatus {
        UNKNOWN,
        CONNECTION,
        DISCONNECTION;

    }
}

