/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.data.RichText;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.Tag;
import org.ametys.core.observation.Event;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.tag.TagAwareAmetysObject;
import org.ametys.plugins.workspaces.forum.AbstractWorkspaceThreadDAO;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.ThreadCategoryEnum;
import org.ametys.plugins.workspaces.forum.filters.AcceptedFilter;
import org.ametys.plugins.workspaces.forum.filters.CategoryFilter;
import org.ametys.plugins.workspaces.forum.filters.CloseFilter;
import org.ametys.plugins.workspaces.forum.filters.NotificationFilter;
import org.ametys.plugins.workspaces.forum.filters.TagFilter;
import org.ametys.plugins.workspaces.forum.filters.TextSearchFilter;
import org.ametys.plugins.workspaces.forum.filters.ThreadFilter;
import org.ametys.plugins.workspaces.forum.jcr.JCRThread;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class WorkspaceThreadDAO
extends AbstractWorkspaceThreadDAO {
    public static final String ROLE = WorkspaceThreadDAO.class.getName();
    public static final String RIGHTS_HANDLE_ALL_THREAD = "Plugin_Workspace_Handle_All_Thread";
    public static final String RIGHTS_REPORT_NOTIFICATION = "Plugins_Workspaces_Handle_Reported_Comment_Thread";
    public static final String RIGHTS_CREATE_THREAD = "Plugin_Workspace_Create_Thread";
    public static final String RIGHTS_CONTRIBUTE_THREAD = "Plugin_Workspace_Contribute_To_Thread";
    public static final String RIGHTS_DELETE_OWN_THREAD = "Plugin_Workspace_Delete_Own_Thread";
    public static final String RIGHTS_DELETE_OWN_THREAD_ANSWERS = "Plugin_Workspace_Delete_Own_Thread_Answers";
    public static final String RIGHTS_REPORT_NOTIFICATION_OWN_THREAD = "Plugins_Workspaces_Handle_Reported_Comment_Own_Thread";
    protected ProjectTagProviderExtensionPoint _tagProviderExtPt;
    protected UserPreferencesManager _userPrefsManager;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._tagProviderExtPt = (ProjectTagProviderExtensionPoint)((Object)manager.lookup(ProjectTagProviderExtensionPoint.ROLE));
        this._userPrefsManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
    }

    @Callable
    public Map<String, Object> addThread(Map<String, Object> parameters, String search, String category, String tag, Boolean closed, List<Part> newFiles, List<String> newFileNames, Boolean accepted, Boolean hasNotification) throws IllegalAccessException {
        String projectName = this._getProjectName();
        ModifiableTraversableAmetysObject threadsRoot = this._getThreadRoot(projectName);
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_HANDLE_ALL_THREAD, (Object)threadsRoot) != RightManager.RightResult.RIGHT_ALLOW && this._rightManager.hasRight(this._currentUserProvider.getUser(), RIGHTS_CREATE_THREAD, (Object)threadsRoot) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to do operation without convenient right(s) Plugin_Workspace_Handle_All_Thread or Plugin_Workspace_Create_Thread");
        }
        int index = 1;
        Object name = "thread-1";
        while (threadsRoot.hasChild((String)name)) {
            name = "thread-" + ++index;
        }
        JCRThread thread = (JCRThread)threadsRoot.createChild((String)name, "ametys:forum-thread");
        ZonedDateTime now = ZonedDateTime.now();
        thread.setCreationDate(now);
        thread.setLastContribution(now);
        thread.setAuthor(this._currentUserProvider.getUser());
        List<Map<String, Object>> newTags = this._editThreadByParameters(thread, parameters, newFiles, newFileNames, new ArrayList<String>());
        thread.saveChanges();
        this._workspaceThreadUserPrefDAO.clearUnopenedThreadNotification(thread.getId());
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this._getSitemapLanguage(), this._getSiteName(), false);
        threadAsJSON.put("passFilter", this._passFilters(thread, search, category, tag, closed, accepted, hasNotification));
        this._notifyEvent(thread, "forumthread.created");
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("thread", threadAsJSON);
        results.put("newTags", newTags);
        return results;
    }

    @Callable
    public Map<String, Object> editThread(Map<String, Object> parameters, String search, String category, String tag, Boolean closed, List<Part> newFiles, List<String> newFileNames, List<String> deleteFiles, Boolean accepted, Boolean hasNotification) throws IllegalAccessException {
        String projectName = this._getProjectName();
        ModifiableTraversableAmetysObject threadsRoot = this._getThreadRoot(projectName);
        String threadId = (String)parameters.get("id");
        JCRThread thread = this._getThreadByID(threadId);
        this._checkUserRights((AmetysObject)threadsRoot, RIGHTS_HANDLE_ALL_THREAD, thread, RIGHTS_CREATE_THREAD);
        boolean wasOpen = thread.getCloseAuthor() == null;
        List<Map<String, Object>> newTags = this._editThreadByParameters(thread, parameters, newFiles, newFileNames, deleteFiles);
        thread.saveChanges();
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this._getSitemapLanguage(), this._getSiteName(), true);
        threadAsJSON.put("passFilter", this._passFilters(thread, search, category, tag, closed, accepted, hasNotification));
        if (wasOpen && thread.getCloseAuthor() != null) {
            this._notifyEvent(thread, "forumthread.closed");
        } else {
            this._notifyEvent(thread, "forumthread.modified");
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("thread", threadAsJSON);
        results.put("newTags", newTags);
        return results;
    }

    private List<Map<String, Object>> _editThreadByParameters(JCRThread thread, Map<String, Object> parameters, List<Part> newFiles, List<String> newFileNames, List<String> deleteFiles) {
        this._checkValidParameters(parameters);
        this._setAttachments(thread, newFiles, newFileNames, deleteFiles);
        String label = (String)parameters.get("title");
        thread.setTitle(label);
        String description = (String)parameters.getOrDefault("contentEditing", "");
        try {
            RichText richText = thread.getContent() != null ? thread.getContent() : new RichText();
            this._richTextTransformer.transform(description, richText);
            thread.setContent(richText);
        }
        catch (IOException | AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to transform the text " + description + " into a rich text for thread " + thread.getId(), e);
        }
        String category = (String)parameters.get("category");
        thread.setCategory(ThreadCategoryEnum.valueOf(category));
        ZonedDateTime now = ZonedDateTime.now();
        thread.setLastModified(now);
        List tags = parameters.getOrDefault("tags", new ArrayList());
        List<Map<String, Object>> createdTagsJson = this._handleTags(thread, tags);
        String closeDateString = (String)parameters.get("closeDate");
        if (closeDateString != null) {
            thread.setCloseDate(DateUtils.parseZonedDateTime((String)closeDateString));
            thread.setCloseAuthor(this._currentUserProvider.getUser());
        } else {
            thread.setCloseDate(null);
            thread.setCloseAuthor(null);
        }
        return createdTagsJson;
    }

    @Callable
    public Map<String, Object> deleteThread(String id) throws IllegalAccessException {
        JCRThread thread = this._getThreadByID(id);
        String projectName = this._getProjectName();
        ModifiableTraversableAmetysObject threadsRoot = this._getThreadRoot(projectName);
        this._checkUserRights((AmetysObject)threadsRoot, RIGHTS_HANDLE_ALL_THREAD, thread, RIGHTS_DELETE_OWN_THREAD);
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this._getSitemapLanguage(), this._getSiteName(), false);
        this._notifyEvent(thread, "forumthread.deleted");
        thread.remove();
        thread.saveChanges();
        return threadAsJSON;
    }

    private void _checkValidParameters(Map<String, Object> parameters) {
        String label = (String)parameters.get("title");
        if (StringUtils.isBlank((CharSequence)label)) {
            throw new IllegalArgumentException("Thread label is mandatory to create a new thread");
        }
        if (StringUtils.length((CharSequence)label) > 100) {
            throw new IllegalArgumentException("Thread label should not exceeds 100 characters");
        }
        String category = (String)parameters.get("category");
        if (!EnumUtils.isValidEnum(ThreadCategoryEnum.class, (String)category)) {
            throw new IllegalArgumentException("Invalid category");
        }
    }

    @Callable
    public Integer getCategoryThreadCount(String category) throws IllegalAccessException {
        ThreadCategoryEnum cat = ThreadCategoryEnum.valueOf(category);
        String projectName = this._getProjectName();
        Project project = this._projectManager.getProject(projectName);
        ModifiableResourceCollection moduleRoot = this._getModuleRoot(projectName);
        this._checkUserReadingRights((AmetysObject)moduleRoot);
        return this.getProjectThreads(project, false).stream().filter(thread -> thread.getCategory().equals((Object)cat)).collect(Collectors.toList()).size();
    }

    @Callable
    public List<String> getThreadIds(String search, String category, String tag, Boolean closed, Boolean accepted, Boolean hasNotification) throws IllegalAccessException {
        String projectName = this._getProjectName();
        ModifiableResourceCollection moduleRoot = this._getModuleRoot(projectName);
        this._checkUserReadingRights((AmetysObject)moduleRoot);
        Project project = this._projectManager.getProject(projectName);
        return this.getProjectThreads(project, true).stream().filter(thread -> this._passFilters((Thread)thread, search, category, tag, closed, accepted, hasNotification)).map(AmetysObject::getId).toList();
    }

    @Callable
    public List<Map<String, Object>> getThreadsByIds(List<String> threadIds) throws IllegalAccessException {
        String projectName = this._getProjectName();
        ModifiableResourceCollection moduleRoot = this._getModuleRoot(projectName);
        this._checkUserReadingRights((AmetysObject)moduleRoot);
        String sitemapLanguage = this._getSitemapLanguage();
        String siteName = this._getSiteName();
        return threadIds.stream().map(this::_getThreadByID).map(thread -> {
            Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON((Thread)thread, sitemapLanguage, siteName, false);
            return threadAsJSON;
        }).toList();
    }

    private boolean _passFilters(Thread thread, String search, String category, String tag, Boolean closed, Boolean accepted, Boolean hasNotification) {
        ArrayList<ThreadFilter> filters = new ArrayList<ThreadFilter>();
        filters.add(new TextSearchFilter(search, this._threadJSONHelper));
        filters.add(new CategoryFilter(category));
        filters.add(new TagFilter(tag));
        filters.add(new CloseFilter(closed));
        filters.add(new AcceptedFilter(accepted));
        filters.add(new NotificationFilter(hasNotification, this._workspaceThreadUserPrefDAO));
        return filters.stream().allMatch(filter -> filter.passFilter(thread));
    }

    @Callable
    public Map<String, Object> getThread(String id) throws IllegalAccessException {
        ModifiableResourceCollection moduleRoot = this._getModuleRoot();
        this._checkUserReadingRights((AmetysObject)moduleRoot);
        if (!this._resolver.hasAmetysObjectForId(id)) {
            return null;
        }
        Thread thread = (Thread)this._resolver.resolveById(id);
        Map<String, Object> threadAsJSON = this._threadJSONHelper.threadAsJSON(thread, this._getSitemapLanguage(), this._getSiteName());
        return threadAsJSON;
    }

    public List<Thread> getProjectThreads(Project project, boolean sortByCreationDate) {
        ForumWorkspaceModule forumModule = (ForumWorkspaceModule)this._workspaceModuleEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        ModifiableResourceCollection forumsRoot = forumModule.getModuleRoot(project, true);
        Stream<Thread> stream = forumsRoot.getChildren().stream().filter(Thread.class::isInstance).map(Thread.class::cast);
        if (sortByCreationDate) {
            stream = stream.sorted(Comparator.comparing(Thread::getLastContribution).reversed());
        }
        return stream.collect(Collectors.toList());
    }

    public Long getThreadsCount(Project project) {
        return this.getProjectThreads(project, false).size();
    }

    @Callable
    public Map<String, Object> getUserRights() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ModifiableResourceCollection threadRoot = this._getModuleRoot();
        UserIdentity user = this._currentUserProvider.getUser();
        results.put("canHandleAllThread", this._rightManager.hasRight(user, RIGHTS_HANDLE_ALL_THREAD, (Object)threadRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canHandleReports", this._rightManager.hasRight(user, RIGHTS_REPORT_NOTIFICATION, (Object)threadRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canCreateThread", this._rightManager.hasRight(user, RIGHTS_CREATE_THREAD, (Object)threadRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canContribute", this._rightManager.hasRight(user, RIGHTS_CONTRIBUTE_THREAD, (Object)threadRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canDeleteOwnThread", this._rightManager.hasRight(user, RIGHTS_DELETE_OWN_THREAD, (Object)threadRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canDeleteOwnThreadMessages", this._rightManager.hasRight(user, RIGHTS_DELETE_OWN_THREAD_ANSWERS, (Object)threadRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canHandleReportsOwnThread", this._rightManager.hasRight(user, RIGHTS_REPORT_NOTIFICATION_OWN_THREAD, (Object)threadRoot) == RightManager.RightResult.RIGHT_ALLOW);
        return results;
    }

    @Callable
    public Set<Map<String, Object>> getUsedTags() {
        String projectName = this._getProjectName();
        Project project = this._projectManager.getProject(projectName);
        return this.getProjectThreads(project, false).stream().map(TagAwareAmetysObject::getTags).flatMap(Collection::stream).map(tag -> (DefaultTag)this._tagProviderExtPt.getTag((String)tag, Collections.emptyMap())).filter(Objects::nonNull).map(tag -> this._projectTagsDAO.tagToJSON((Tag)tag)).collect(Collectors.toSet());
    }

    private void _notifyEvent(JCRThread thread, String eventId) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("forumthreadthread", thread);
        eventParams.put("object.id", thread.getId());
        this._observationManager.notify(new Event(eventId, this._currentUserProvider.getUser(), eventParams));
    }
}

