/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.rights.accesscontroller;

import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.right.AccessController;
import org.ametys.core.right.AccessExplanation;
import org.ametys.core.right.RightManager;
import org.ametys.core.right.RightProfilesDAO;
import org.ametys.core.right.RightsException;
import org.ametys.core.right.RightsExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.core.impl.right.WorkspaceAccessController;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.WebHelper;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.SitemapElement;
import org.ametys.web.repository.site.Site;
import org.ametys.web.repository.site.SiteManager;
import org.ametys.web.repository.sitemap.Sitemap;
import org.ametys.web.rights.PageAccessController;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

public class BackOfficeAccessController
implements AccessController,
Serviceable,
Contextualizable,
PluginAware {
    private static final String __BO_ACCESS_RIGHT_ID = "Plugins_Workspaces_Rights_Project_BOAccess";
    private static final String __ALL_PAGE_FAKE_CONTEXT = "$ALL_PAGES$";
    protected RightsExtensionPoint _rightsEP;
    private String _adminProfileIdentifier;
    private RightProfilesDAO _rightProfileDAO;
    private SiteManager _siteManager;
    private ProjectManager _projectManager;
    private RightManager _rightManager;
    private Context _context;
    private String _id;

    public void service(ServiceManager manager) throws ServiceException {
        this._rightProfileDAO = (RightProfilesDAO)manager.lookup(RightProfilesDAO.ROLE);
        this._siteManager = (SiteManager)manager.lookup(SiteManager.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._rightsEP = (RightsExtensionPoint)manager.lookup(RightsExtensionPoint.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
    }

    public boolean isSupported(Object object) {
        return object instanceof String && ((String)object).startsWith("/cms") || object instanceof SitemapElement;
    }

    private Project _getProject(Object object) {
        Site site = null;
        if (object instanceof SitemapElement) {
            SitemapElement se = (SitemapElement)object;
            site = se.getSite();
        } else {
            Request request = ContextHelper.getRequest((Context)this._context);
            String siteName = WebHelper.getSiteName((Request)request);
            if (StringUtils.isNotBlank((CharSequence)siteName)) {
                site = this._siteManager.getSite(siteName);
            }
        }
        if (site != null) {
            List<Project> projectsForSite = this._projectManager.getProjectsForSite(site);
            Project project = (Project)((Object)Iterables.getFirst(projectsForSite, null));
            return project;
        }
        return null;
    }

    private boolean _isRightInAdminProfile(String rightId) {
        if (rightId == null) {
            return true;
        }
        return this._getRightsInAdminProfile().contains(rightId);
    }

    private boolean _hasBOAccessRight(UserIdentity user) {
        try {
            return this._rightManager.hasRight(user, __BO_ACCESS_RIGHT_ID, (Object)("/site/" + this._projectManager.getCatalogSiteName())) == RightManager.RightResult.RIGHT_ALLOW;
        }
        catch (ProjectManager.UnknownCatalogSiteException e) {
            return false;
        }
    }

    private synchronized List<String> _getRightsInAdminProfile() {
        if (this._adminProfileIdentifier == null) {
            this._adminProfileIdentifier = (String)Config.getInstance().getValue("workspaces.profile.managerdefault");
        }
        return this._rightProfileDAO.getRights(this._adminProfileIdentifier);
    }

    public AccessController.AccessResult getPermission(UserIdentity user, Set<GroupIdentity> userGroups, String rightId, Object object) {
        Project project;
        if (this._isRightInAdminProfile(rightId) && (project = this._getProject(object)) != null && this._projectManager.isManager(project, user) && this._hasBOAccessRight(user)) {
            return AccessController.AccessResult.USER_ALLOWED;
        }
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermission(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        return this.getPermission(user, userGroups, null, object);
    }

    public Map<String, AccessController.AccessResult> getPermissionByRight(UserIdentity user, Set<GroupIdentity> userGroups, Object object) {
        Project project = this._getProject(object);
        if (project != null && this._projectManager.isManager(project, user) && this._hasBOAccessRight(user)) {
            return this._getRightsInAdminProfile().stream().collect(Collectors.toMap(rightId -> rightId, rightId -> AccessController.AccessResult.USER_ALLOWED));
        }
        return Map.of();
    }

    public AccessController.AccessResult getPermissionForAnonymous(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnonymous(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getPermissionForAnyConnectedUser(String rightId, Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public AccessController.AccessResult getReadAccessPermissionForAnyConnectedUser(Object object) {
        return AccessController.AccessResult.UNKNOWN;
    }

    public Map<UserIdentity, AccessController.AccessResult> getPermissionByUser(String rightId, Object object) {
        Project project;
        if (this._isRightInAdminProfile(rightId) && (project = this._getProject(object)) != null) {
            return Stream.of(project.getManagers()).distinct().filter(this::_hasBOAccessRight).collect(Collectors.toMap(user -> user, user -> AccessController.AccessResult.USER_ALLOWED));
        }
        return Map.of();
    }

    public Map<UserIdentity, AccessController.AccessResult> getReadAccessPermissionByUser(Object object) {
        return this.getPermissionByUser(null, object);
    }

    public Map<GroupIdentity, AccessController.AccessResult> getPermissionByGroup(String rightId, Object object) {
        return Map.of();
    }

    public Map<GroupIdentity, AccessController.AccessResult> getReadAccessPermissionByGroup(Object object) {
        return Map.of();
    }

    public boolean hasUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups, String rightId) {
        Project project;
        return this._isRightInAdminProfile(rightId) && workspacesContexts.contains("/cms") && (project = this._getProject("/cms")) != null && this._projectManager.isManager(project, user) && this._hasBOAccessRight(user);
    }

    public boolean hasUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts, UserIdentity user, Set<GroupIdentity> userGroups) {
        return this.hasUserAnyPermissionOnWorkspace(workspacesContexts, user, userGroups, null);
    }

    public boolean hasAnonymousAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnonymousAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyPermissionOnWorkspace(Set<Object> workspacesContexts, String rightId) {
        return false;
    }

    public boolean hasAnyConnectedUserAnyReadAccessPermissionOnWorkspace(Set<Object> workspacesContexts) {
        return false;
    }

    public AccessExplanation getStandardAccessExplanation(AccessController.AccessResult permission, Object object) {
        switch (permission) {
            case USER_ALLOWED: 
            case UNKNOWN: {
                return new AccessExplanation(this.getId(), permission, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_BACK_OFFICE_ACCESS_CONTROLLER_" + permission.name() + "_EXPLANATION", Map.of("right", this._rightsEP.getExtension(__BO_ACCESS_RIGHT_ID).getLabel(), "objectLabel", this._getObjectLabelForExplanation(object))));
            }
        }
        return AccessController.getDefaultAccessExplanation((String)this.getId(), (AccessController.AccessResult)permission);
    }

    private I18nizableText _getObjectLabelForExplanation(Object object) {
        if (object instanceof String) {
            String str = (String)object;
            if (__ALL_PAGE_FAKE_CONTEXT.equals(str)) {
                return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_BACK_OFFICE_ACCESS_CONTROLLER_ALL_PAGE_EXPLANATION_OBJECT_LABEL");
            }
            return new I18nizableText("plugin.web", "PLUGINS_WEB_WORKSPACE_ACCESS_CONTROLLER_CONTEXT_LABEL", Map.of("object", new I18nizableText(str)));
        }
        if (object instanceof Page) {
            return new I18nizableText("plugin.web", "PLUGINS_WEB_PAGE_ACCESS_CONTROLLER_PAGE_CONTEXT_EXPLANATION_LABEL", Map.of("title", this.getObjectLabel(object)));
        }
        if (object instanceof Sitemap) {
            Sitemap sitemap = (Sitemap)object;
            return new I18nizableText("plugin.web", "PLUGINS_WEB_PAGE_ACCESS_CONTROLLER_SITEMAP_CONTEXT_EXPLANATION_LABEL", Map.of("name", new I18nizableText(sitemap.getSitemapName().toUpperCase())));
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public I18nizableText getObjectLabel(Object object) {
        if (object instanceof String) {
            String str = (String)object;
            if (__ALL_PAGE_FAKE_CONTEXT.equals(str)) {
                return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_BACK_OFFICE_ACCESS_CONTROLLER_ALL_PAGE_OBJECT_LABEL");
            }
            return WorkspaceAccessController.GENERAL_CONTEXT_CATEGORY;
        }
        if (object instanceof Page) {
            Page page = (Page)object;
            return new I18nizableText(PageAccessController.getPageObjectLabel((Page)page));
        }
        if (object instanceof Sitemap) {
            Sitemap sitemap = (Sitemap)object;
            return new I18nizableText("plugin.web", "PLUGINS_WEB_PAGE_ACCESS_CONTROLLER_SITEMAP_CONTEXT_LABEL", Map.of("name", new I18nizableText(sitemap.getSitemapName().toUpperCase())));
        }
        throw new RightsException("Unsupported object " + object.toString());
    }

    public Map<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> explainAllPermissions(UserIdentity identity, Set<GroupIdentity> groups) {
        HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>> result = new HashMap<AccessController.ExplanationObject, Map<AccessController.Permission, AccessExplanation>>();
        AccessController.AccessResult accessResult = this.getPermission(identity, groups, null, null);
        if (accessResult != AccessController.AccessResult.UNKNOWN) {
            AccessExplanation explanation = this.getStandardAccessExplanation(accessResult, "/cms");
            Map<AccessController.Permission, AccessExplanation> contextPermission = Map.of(new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, this._adminProfileIdentifier), explanation, new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), explanation);
            result.put(this.getExplanationObject("/cms"), contextPermission);
            explanation = this.getStandardAccessExplanation(accessResult, __ALL_PAGE_FAKE_CONTEXT);
            contextPermission = Map.of(new AccessController.Permission(AccessController.Permission.PermissionType.PROFILE, this._adminProfileIdentifier), explanation, new AccessController.Permission(AccessController.Permission.PermissionType.READ, null), explanation);
            result.put(this.getExplanationObject(__ALL_PAGE_FAKE_CONTEXT), contextPermission);
        }
        return result;
    }

    public I18nizableText getObjectCategory(Object object) {
        if (object instanceof String) {
            if (__ALL_PAGE_FAKE_CONTEXT.equals(object)) {
                return PageAccessController.PAGE_CONTEXT_CATEGORY;
            }
            return WorkspaceAccessController.GENERAL_CONTEXT_CATEGORY;
        }
        if (object instanceof SitemapElement) {
            return PageAccessController.PAGE_CONTEXT_CATEGORY;
        }
        throw new RightsException("Unsupported context: " + object.toString());
    }

    public int getObjectPriority(Object object) {
        if (__ALL_PAGE_FAKE_CONTEXT.equals(object)) {
            return 10;
        }
        return super.getObjectPriority(object);
    }

    public String getId() {
        return this._id;
    }
}

