/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.cms.tag.AbstractTagsDAO;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.TagProvider;
import org.ametys.cms.tag.jcr.AbstractJCRTagsDAO;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tags.ProjectJCRTagProvider;
import org.ametys.plugins.workspaces.tags.ProjectJCRTagsDAO;
import org.ametys.plugins.workspaces.tags.ProjectTagProviderExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ProjectTagsDAO
extends AbstractTagsDAO {
    public static final String ROLE = ProjectTagsDAO.class.getName();
    protected RightManager _rightManager;
    protected ProjectJCRTagsDAO _projectJCRDAO;
    protected WorkspaceModuleExtensionPoint _workspaceModuleEP;
    protected ProjectManager _projectManager;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._projectJCRDAO = (ProjectJCRTagsDAO)((Object)manager.lookup(ProjectJCRTagsDAO.ROLE));
        this._workspaceModuleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
    }

    public String getTagProviderEPRole() {
        return ProjectTagProviderExtensionPoint.ROLE;
    }

    protected List<TagProvider<? extends Tag>> getCustomTagProvider() {
        ArrayList<TagProvider<? extends Tag>> providers = new ArrayList<TagProvider<? extends Tag>>();
        providers.add((TagProvider)this._tagProviderExtPt.getExtension(ProjectJCRTagProvider.class.getName()));
        return providers;
    }

    @Callable
    public Map<String, Object> getProjectTags(String moduleId, String projectName) {
        ArrayList tags = new ArrayList();
        for (String id : this._tagProviderExtPt.getExtensionsIds()) {
            TagProvider tagProvider = (TagProvider)this._tagProviderExtPt.getExtension(id);
            Map someTags = tagProvider.getTags(Collections.emptyMap());
            tags.addAll(this._tagsToJSON(someTags.values()));
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("tags", tags);
        Project project = this._projectManager.getProject(projectName);
        Object module = this._workspaceModuleEP.getModule(moduleId);
        result.put("canCreate", this._rightManager.currentUserHasRight("Workspace_Rights_Tags_HandleTag", (Object)module.getModuleRoot(project, false)) == RightManager.RightResult.RIGHT_ALLOW);
        return result;
    }

    protected AbstractJCRTagsDAO _getTagJCRDAO() {
        return this._projectJCRDAO;
    }
}

