/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.data.Resource;
import org.ametys.cms.repository.AttachableAmetysObject;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.WorkspaceTaskDAO;
import org.ametys.plugins.workspaces.util.StatisticColumn;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.ZoneItem;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;

public class TasksWorkspaceModule
extends AbstractWorkspaceModule {
    public static final String TASK_MODULE_ID = TasksWorkspaceModule.class.getName();
    private static final String __WORKSPACES_TASKS_NODE_NAME = "tasks";
    private static final String __WORKSPACES_TASKS_ROOT_NODE_NAME = "tasks-root";
    private static final String __WORKSPACES_TASKS_LIST_ROOT_NODE_NAME = "tasks-list-root";
    private static final String __TASK_NUMBER_HEADER_ID = "tasks$task_number";
    private WorkspaceTaskDAO _workspaceTaskDAO;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._workspaceTaskDAO = (WorkspaceTaskDAO)((Object)serviceManager.lookup(WorkspaceTaskDAO.ROLE));
    }

    @Override
    public String getId() {
        return TASK_MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return __WORKSPACES_TASKS_NODE_NAME;
    }

    @Override
    public int getOrder() {
        return 50;
    }

    @Override
    protected String getModulePageName() {
        return __WORKSPACES_TASKS_NODE_NAME;
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_TASK_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_TASK_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_TASKS_TITLE");
    }

    @Override
    protected void initializeModulePage(ModifiablePage taskPage) {
        ModifiableZone defaultZone = taskPage.createZone("default");
        String serviceId = "org.ametys.plugins.workspaces.module.Tasks";
        ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
        defaultZoneItem.setType(ZoneItem.ZoneType.SERVICE);
        defaultZoneItem.setServiceId(serviceId);
        ModifiableModelAwareDataHolder serviceDataHolder = defaultZoneItem.getServiceParameters();
        serviceDataHolder.setValue("xslt", (Object)this._getDefaultXslt(serviceId));
    }

    @Callable
    public Map<String, Object> getTasksModuleRights() {
        HashMap<String, Object> rights = new HashMap<String, Object>();
        Request request = ContextHelper.getRequest((Context)this._context);
        String projectName = (String)request.getAttribute("projectName");
        Project project = this._projectManager.getProject(projectName);
        ModifiableResourceCollection tasksRoot = this.getModuleRoot(project, false);
        UserIdentity currentUser = this._currentUserProvider.getUser();
        rights.put("view", tasksRoot != null && this._rightManager.hasRight(currentUser, "Plugin_Workspace_Handle_Task", (Object)tasksRoot) == RightManager.RightResult.RIGHT_ALLOW);
        rights.put("add", tasksRoot != null && this._rightManager.hasRight(currentUser, "Plugin_Workspace_Handle_Task", (Object)tasksRoot) == RightManager.RightResult.RIGHT_ALLOW);
        return rights;
    }

    @Callable
    public Map<String, Object> getTasksServiceRights(List<String> projectNames) {
        HashMap<String, Object> rights = new HashMap<String, Object>();
        ArrayList<String> rightAdd = new ArrayList<String>();
        UserIdentity currentUser = this._currentUserProvider.getUser();
        for (String projectName : projectNames) {
            Project project = this._projectManager.getProject(projectName);
            ModifiableResourceCollection tasksRoot = this.getModuleRoot(project, false);
            if (tasksRoot == null || this._rightManager.hasRight(currentUser, "Plugin_Workspace_Handle_Task", (Object)tasksRoot) != RightManager.RightResult.RIGHT_ALLOW) continue;
            rightAdd.add(projectName);
        }
        rights.put("add", rightAdd);
        return rights;
    }

    public String getTaskUri(Project project, String taskId) {
        String moduleUrl = this.getModuleUrl(project);
        if (moduleUrl != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(moduleUrl);
            sb.append("#task-").append(taskId);
            return sb.toString();
        }
        return null;
    }

    public DefaultTraversableAmetysObject getTasksRoot(Project project, boolean create) {
        ModifiableResourceCollection moduleRoot = this.getModuleRoot(project, create);
        return (DefaultTraversableAmetysObject)this._getAmetysObject((ModifiableTraversableAmetysObject)moduleRoot, __WORKSPACES_TASKS_ROOT_NODE_NAME, "ametys:resources-collection", create);
    }

    public DefaultTraversableAmetysObject getTasksListsRoot(Project project, boolean create) {
        ModifiableResourceCollection moduleRoot = this.getModuleRoot(project, create);
        return (DefaultTraversableAmetysObject)this._getAmetysObject((ModifiableTraversableAmetysObject)moduleRoot, __WORKSPACES_TASKS_LIST_ROOT_NODE_NAME, "ametys:resources-collection", create);
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return ImmutableSet.of((Object)"task.created", (Object)"task.assigned", (Object)"task.closed.status.changed", (Object)"task.deleting");
    }

    @Override
    public Map<String, Object> _getInternalStatistics(Project project, boolean isActive) {
        if (isActive) {
            return Map.of(__TASK_NUMBER_HEADER_ID, this._workspaceTaskDAO.getTasksCount(project));
        }
        return Map.of(__TASK_NUMBER_HEADER_ID, __SIZE_INACTIVE);
    }

    @Override
    protected long _getModuleSize(Project project) {
        return this._workspaceTaskDAO.getProjectTasks(project).stream().map(AttachableAmetysObject::getAttachments).flatMap(Collection::stream).mapToLong(Resource::getLength).sum();
    }

    @Override
    public List<StatisticColumn> _getInternalStatisticModel() {
        return List.of(new StatisticColumn(__TASK_NUMBER_HEADER_ID, new I18nizableText("plugin.workspaces", "PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_COLUMN_TASK_NUMBER")).withRenderer("Ametys.plugins.workspaces.project.tool.ProjectsGridHelper.renderElements").withType(StatisticsColumnType.LONG).withGroup("general$elements"));
    }

    @Override
    protected boolean _showModuleSize() {
        return true;
    }
}

