/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.data.Binary;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.tasks.Task;
import org.ametys.plugins.workspaces.util.WorkspaceObjectJSONHelper;
import org.apache.avalon.framework.component.Component;

public class TaskJSONHelper
extends WorkspaceObjectJSONHelper
implements Component {
    public static final String ROLE = TaskJSONHelper.class.getName();

    public Map<String, Object> taskAsJSON(Task task, String lang, String siteName) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", task.getId());
        json.put("label", task.getLabel());
        json.put("description", task.getDescription());
        json.put("tasksListId", task.getTaskListId());
        json.put("position", task.getPosition());
        json.put("creationDate", task.getCreationDate());
        json.put("closeInfo", this._closeInfoAsJson(task));
        json.put("assignments", this._assignmentsToJson(task));
        json.put("tags", this._getTags(task, siteName));
        List attachments = task.getAttachments().stream().map(x$0 -> this._binaryToJson((Binary)x$0)).collect(Collectors.toList());
        json.put("attachments", attachments);
        json.put("checkList", this._checkListToJson(task));
        json.put("comments", this._commentsToJson(task.getComments(true, true), lang, siteName));
        json.put("dueDate", task.getDueDate());
        json.put("datePassed", task.isClosed());
        return json;
    }

    private Map<String, Object> _closeInfoAsJson(Task task) {
        UserIdentity closeAuthor = task.getCloseAuthor();
        return task.isClosed() ? Map.of("closeAuthor", this._userHelper.user2json(closeAuthor), "closeDate", task.getCloseDate()) : null;
    }

    private List<Map<String, Object>> _assignmentsToJson(Task task) {
        return task.getAssignments().stream().map(u -> this._userHelper.user2json(u)).collect(Collectors.toList());
    }

    private List<Map<String, Object>> _checkListToJson(Task task) {
        ArrayList<Map<String, Object>> json = new ArrayList<Map<String, Object>>();
        for (Task.CheckItem checkItem : task.getCheckList()) {
            json.add(Map.of("label", checkItem.getLabel(), "isChecked", checkItem.isChecked()));
        }
        return json;
    }
}

