/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const activityTypeExtensionPoint = Ametys.serviceManager.lookup('org.ametys.plugins.repository.activities.ActivityTypeExtensionPoint');

logger.info("Start migration of activities for default session");
migrateActivityNodes(Repository.session);

logger.info("Start migration of activities for live session");
migrateActivityNodes(Repository.liveSession);

function migrateActivityNodes(session) 
{
    let count = 0;
    const xpath = "//element(*, ametys:activity)";
    const activityNodes = Repository.query(xpath, false, session);
            
    while (activityNodes.hasNext())
    {
        let node = activityNodes.next();
        if (!node.hasProperty("ametys:activityTypeId"))
        {
            migrateActivityNode(node);
            count++;
        }
    }
    
    logger.info(`${count} activities have been migrated in ${session.getWorkspace().getName()} workspace`);
    session.save();
}

function migrateActivityNode(node)
{
    let typeId = "";
    let eventId = node.getProperty("ametys:type").getString();
    for (let type of activityTypeExtensionPoint.getActivityTypes(eventId))
    {
        if (type instanceof org.ametys.plugins.workspaces.activities.AbstractWorkspacesActivityType)
        {
            // We can take the first because in the workspaces conception, one event is linked to one activity type
            typeId = type.getId();
            break;
        }
    }
  
    node.setProperty("ametys:activityTypeId", typeId);
}

