/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

// Register old nodetypes, as they need to be registered to be removed
Repository.registerNodeType("post");
Repository.registerNodeType("thread");

logger.info("Start migration of old thread module for default session");
removeThreadNodeFromResources(Repository.session);
removeThreadNodeFromSitemap(Repository.session);

logger.info("Start migration of old thread module for live session");
removeThreadNodeFromResources(Repository.liveSession);
removeThreadNodeFromSitemap(Repository.liveSession);

function removeThreadNodeFromResources(session) 
{
    let count = 0;
    const xpath = "//element(*, ametys:project)/ametys-internal:resources/threads";
    const activityNodes = Repository.query(xpath, false, session);
            
    while (activityNodes.hasNext())
    {
        let node = activityNodes.next();
        node.remove();
        
        count++;
    }
    
    logger.info(`${count} project with old thread module in the resources have been migrated in ${session.getWorkspace().getName()} workspace`);
    session.save();
}

function removeThreadNodeFromSitemap(session) 
{
    let count = 0;
    const xpath = "//element(*, ametys:sitemap)/forum";
    const activityNodes = Repository.query(xpath, false, session);
            
    while (activityNodes.hasNext())
    {
        let node = activityNodes.next();
        node.remove();
        
        count++;
    }
    
    logger.info(`${count} project with old thread module in the sitemap have been migrated in ${session.getWorkspace().getName()} workspace`);
    session.save();
}
