<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:su="org.apache.commons.lang3.StringUtils"
                xmlns:datetime="http://ametys.org/datetime/4.2"
                extension-element-prefixes="resolver su">
    
    <xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>
    <xsl:import href="event.xsl"/>
    
    <xsl:variable name="nl"><xsl:text>&#13;&#10;</xsl:text></xsl:variable>
    <xsl:variable name="nlstr"><xsl:text>\\n</xsl:text></xsl:variable>
        
    <xsl:template match="/">
        <text>            
            <xsl:text>BEGIN:VCALENDAR</xsl:text><xsl:value-of select="$nl"/>
            <xsl:text>VERSION:2.0</xsl:text><xsl:value-of select="$nl"/>
            <xsl:text>PRODID:-//Ametys/calendar//NONSGML v1.0//EN</xsl:text><xsl:value-of select="$nl"/>
            
            <xsl:apply-templates select="ActionResult/events"/>
            
            <xsl:text>END:VCALENDAR</xsl:text><xsl:value-of select="$nl"/>
        </text>
    </xsl:template>
    
    <xsl:template match="events">
        <xsl:text>BEGIN:VEVENT</xsl:text><xsl:value-of select="$nl"/>
        <xsl:text>UID:</xsl:text>
        <xsl:value-of select="id"/>
        <xsl:value-of select="$nl"/>
        <xsl:text>CREATED;VALUE=DATE-TIME:</xsl:text>
        <xsl:value-of select="creationDate"/>
        <xsl:value-of select="$nl"/>
        <xsl:text>LAST-MODIFIED;VALUE=DATE-TIME:</xsl:text>
        <xsl:value-of select="lastModified"/>
        <xsl:value-of select="$nl"/>
        <xsl:text>DTSTAMP;VALUE=DATE-TIME:</xsl:text>
        <xsl:value-of select="lastModified"/>
        <xsl:value-of select="$nl"/>
        
        <xsl:if test="startDate">
            <xsl:text>DTSTART;VALUE=DATE:</xsl:text><xsl:value-of select="startDate"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        <xsl:if test="endDate">
            <xsl:text>DTEND;VALUE=DATE:</xsl:text><xsl:value-of select="endDate"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>

        <xsl:text>SUMMARY:</xsl:text>
        <xsl:value-of select="title"/>
        <xsl:value-of select="$nl"/>
        <xsl:if test="description">
            <xsl:variable name="description" select="description"/>
            <xsl:variable name="description" select="su:replace($description, '\n', '\\n')"/>
            <xsl:variable name="description" select="su:replace($description, '\r', '\\r')"/>
            <xsl:variable name="description" select="su:replacePattern($description, '[\n\r]', $nlstr)"/>
            <xsl:text>DESCRIPTION:</xsl:text>
            <!-- replace each end of line with '\n' -->
            <xsl:value-of select="$description" />
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        <xsl:if test="location">
            <xsl:text>LOCATION:</xsl:text>
            <xsl:value-of select="location"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        
        <xsl:if test="keywords">
            <xsl:text>CATEGORIES:</xsl:text><xsl:apply-templates select="keywords/keywords"/>
            <xsl:value-of select="$nl"/>
        </xsl:if>
        
        <xsl:text>END:VEVENT</xsl:text><xsl:value-of select="$nl"/>
    </xsl:template>
    
    <xsl:template match="keywords">
        <xsl:value-of select="." />
        <xsl:if test="position()!=last()"><xsl:text>,</xsl:text></xsl:if>
    </xsl:template>
    
</xsl:stylesheet>