/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
function __invitations_getInvitationConfiguration(mailDialogId, profileDialogId)
{
    AmetysFront.ServerComm.callMethod({
        role: 'org.ametys.plugins.workspaces.members.ProjectInvitationHelper',
        methodName: 'getInvitationConfiguration',
        parameters: [AmetysFront.getAppParameter('projectName'), AmetysFront.getAppParameter('sitemapLanguage')],
        callback: {
            handler: __invitations_openInvitationDialog,
            scope: this,
            arguments: {
                mailDialogId: mailDialogId,
                profileDialogId: profileDialogId
            }
        }
    });
}
             
function __invitations_openInvitationDialog (data, args)
{
    function _clearInvalid(dialog)
    {
        dialog.find("input").removeClass("error");
        dialog.find("textarea").removeClass("error");
        dialog.find("select").removeClass("error");
        dialog.find(".error-hint").remove();
    }
    
    function _isValid(input)
    {
        if (input.val() == '')
        {
            input.focus();
            input.addClass("error");
            input.after('<p class="error-hint">{{i18n plugin.web:PLUGINS_WEB_FRONTOFICE_MANDATORY_FIELD_ERROR}}</p>');
            return false;            
        }
        return true;
    }
    
    if (data.allowed)
    {
        var dialog = $j('#' + args.mailDialogId),
            inputEmail = dialog.find("input[name='email']"),
            inputSubject = dialog.find("input[name='subject']"),
            inputMsg = dialog.find("textarea[name='message']");
            options = dialog.find("select[name='profile']");
            
        inputSubject.val(data.email.subject);
        inputMsg.text(data.email.bodyText);
    
	    $.each(data.rights.profiles, function(index, item) {
	        options.append($("<option />").val(item.id).text(item.label));
	    });
    
        dialog.dialog({
            // Remove the closing 'X' from the dialog
            open: function(event, ui) { $(".ui-dialog-titlebar-close").hide(); }, 
            modal: true,
            width: 400,
            buttons: [{
                text: "{{i18n PLUGINS_WORKSPACES_INVITATION_DIALOG_CONTINUE_BUTTON}}",
                click: function() {
                    _clearInvalid(dialog)
                    
                    var isValid = _isValid(inputMsg);
                    isValid = _isValid(inputSubject) && isValid;
                    isValid = _isValid(inputEmail) && isValid;
                    
                    if (!isValid)
                        return;
                    
                    var cfg = {
                        email: inputEmail.val(),
                        subject: inputSubject.val(),
                        message: inputMsg.val(),
                        profile: options.val()
                    }
                    
                    $(this).dialog( "close" );
                    __invitations_sendInvitation(data, cfg, args);
                }
            }, {
                text: "{{i18n PLUGINS_WORKSPACES_INVITATION_DIALOG_CANCEL_BUTTON}}",
                click: function() {
                    $(this).dialog( "close" );
                }
            }]
        });
    }
}
             
 function __invitations_sendInvitation(data, cfg, args)
 {
    var emails = $.map(cfg.email.split(","), $.trim); 
    
    var allowedProfileByModule = {};
    
    $.each(data.rights.modules, function(index, module) {
        allowedProfileByModule[module.id] = cfg.profile;
    });
    
    AmetysFront.ServerComm.callMethod({
        role: 'org.ametys.plugins.workspaces.members.ProjectInvitationHelper',
        methodName: 'inviteEmails',
        parameters: [AmetysFront.getAppParameter('projectName'), AmetysFront.getAppParameter('siteName'), AmetysFront.getAppParameter('sitemapLanguage'), emails, allowedProfileByModule, cfg.subject, cfg.message],
        callback: {
            handler: __invitations__sendInvitationCb,
            scope: this
        }
    });
 }
             
 function __invitations__sendInvitationCb(data)
 {
    if (data.success)
    {
        if (data['email-success'].length > 1)
        {
            alert("{{i18n PLUGINS_WORKSPACES_INVITATION_SUCCESS_MULTI}}");
        }
        else
        {
             alert("{{i18n PLUGINS_WORKSPACES_INVITATION_SUCCESS}}");
        }
        return;
    }
    
    if (data['existing-users'].length > 0)
    {
        var existingUsers = "";
        
        $.each(data['existing-users'], function(index, item) {
            existingUsers = existingUsers.concat("\n" + item.fullname + " (" + item.email + ")");
        });
        
        AmetysFront.displayError("{{i18n PLUGINS_WORKSPACES_INVITATION_EXISTING_USERS}}" + existingUsers + "{{i18n PLUGINS_WORKSPACES_INVITATION_EXISTING_USERS_2}}");
    }
    
    if (data['email-error'].length > 0)
    {
        var emailError = "";
        
        $.each(data['email-error'], function(index, item) {
            emailError = emailError.concat("\n" + item);
        });
        
        AmetysFront.displayError("{{i18n PLUGINS_WORKSPACES_INVITATION_ERROR}}" + emailError);
    }
 }
 
 