<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:uri="org.ametys.core.util.URIUtils"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:mail="org.ametys.plugins.workspaces.project.helper.MailXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent">
    
    <xsl:import href="view://stylesheets/mail/abstract2notification.xsl"/>
    
    <xsl:variable name="input-date-format">yyyy-MM-dd'T'HH:mm:ss.SSSXXX</xsl:variable>
    
    <xsl:template match="activity">
        <item type="calendar">
            <color><xsl:value-of select="mail:getCalendarColor(calendarId)"/></color>
            <startDate><xsl:value-of select="eventStartDate"/></startDate>
            <endDate><xsl:value-of select="eventEndDate"/></endDate>
            <fullDay><xsl:value-of select="eventFullDay"/></fullDay>
            
            <xsl:if test="eventRecurrence != 'NEVER' and eventRecurrence != ''">
                <recurrence>
                    <xsl:if test="eventRecurrence != 'NEVER' and eventRecurrence != ''">
                        <xsl:attribute name="until"><xsl:value-of select="eventRepeatUntil"/></xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="eventRecurrence"/>
                </recurrence>
            </xsl:if>
            <title><xsl:value-of select="eventTitle"/></title>
        </item>
    </xsl:template>
    
    <xsl:template name="section-button">
    
        <button>
            <xsl:choose>
                <xsl:when test="activity/type='calendar.event.deleting'">
	                <text>
	                    <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
	                </text>
	                <href>
	                    <xsl:choose>
	                        <xsl:when test="modulePageId != ''"><xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/></xsl:when>
	                        <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
	                    </xsl:choose>
	                </href>
                </xsl:when>
                <xsl:otherwise>
	                <text>
	                    <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_CALENDAR_BUTTON_TEXT" i18n:catalogue="plugin.workspaces"/>
	                </text>
	                <href>
	                    <xsl:choose>
	                        <xsl:when test="modulePageId != ''">
	                            <xsl:value-of select="resolver:resolve('page', modulePageId, false(), true())"/>
	                            <xsl:if test="activity/eventId"><xsl:text>?date=</xsl:text><i18n:date pattern="yyyy-MM-dd" src-pattern="{$input-date-format}"><xsl:value-of select="activity/eventStartDate"/></i18n:date></xsl:if>
	                            <xsl:if test="activity/calendarId"><xsl:text>#</xsl:text><xsl:value-of select="uri:encodeFragment(activity/calendarId)"/></xsl:if>
	                        </xsl:when>
	                        <xsl:otherwise><xsl:value-of select="project/url"/></xsl:otherwise>
	                    </xsl:choose>
	                </href>
                </xsl:otherwise>
            </xsl:choose>
            
		    <width>300</width>
		    <margin-bottom>50</margin-bottom>
		</button>
    </xsl:template>
    
    <xsl:template name="section-link">
        <xsl:if test="activity/type != 'calendar.event.deleting'">
            <xsl:variable name="icslink" select="mail:getCalendarEventICSExportLink(activity/eventId, project/url)"/>
            <xsl:if test="$icslink != ''">
    	        <link>
    	            <text>
    	                <i18n:text i18n:key="PROJECT_MAIL_NOTIFICATION_BODY_DEFAULT_EXPORT_ICS_LINK_TEXT" i18n:catalogue="plugin.workspaces"/>
    	            </text>
    	            <href>
    	                <xsl:value-of select="$icslink"/>
    	            </href>
    	        </link>
            </xsl:if>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>