<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
                
    <xsl:import href="view:workspaces://stylesheets/mail/workspaces/template.xsl"/>

    <xsl:template match="/notification">
        <xsl:call-template name="template"/>
    </xsl:template>
    
    <xsl:template name="content-inner">
        <!-- Title -->
        <xsl:call-template name="content-title">
            <xsl:with-param name="title" select="/notification/title"/>
        </xsl:call-template>
        
        <xsl:choose>
            <xsl:when test="projects">
                <xsl:apply-templates select="projects/project[sections/section/items/item]"/>
                
                <xsl:call-template name="table-vertical-spacer">
                    <xsl:with-param name="height">50</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="sections/section"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="project">
        <xsl:variable name="margin-top">
            <xsl:choose>
                <xsl:when test="position() = 1">10</xsl:when>
                <xsl:otherwise>30</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:call-template name="project-title">
            <xsl:with-param name="title" select="title"/>
            <xsl:with-param name="url" select="projectURL"/>
            <xsl:with-param name="margin-top" select="$margin-top"/>
        </xsl:call-template>
        
<!--         We filter to avoid displaying artefact when dealing with unsupported event type -->
        <xsl:apply-templates select="sections/section[count(items/item) &gt; 0]"/>
    </xsl:template>

    <xsl:template match="section">
        <!-- SECTION HINT -->
        <xsl:apply-templates select="hint">
            <xsl:with-param name="first" select="position() = 1"/>
        </xsl:apply-templates>
        
        <!-- SECTION BLOCK -->
        <xsl:apply-templates select="items"/>
        
        <!-- BUTTON -->
        <xsl:apply-templates select="button"/>
        
        <!-- LINK -->
        <xsl:apply-templates select="link"/>
    </xsl:template>
    
    <!-- 
    <hint>
        <text/>
    </hint>
    -->
    <xsl:template match="hint">
        <xsl:param name="first" select="false()"/>
        
        <xsl:variable name="margin-top">
            <xsl:choose>
                <xsl:when test="$first = true()">0</xsl:when>
                <xsl:otherwise>30</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:call-template name="hint">
            <xsl:with-param name="text" select="."/>
            <xsl:with-param name="margin-top" select="$margin-top"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- 
    <button>
        <href/>
        <text/>
        <width/>
        <offset-bottom/>
    </button>
    -->
    <xsl:template match="button">
        <xsl:variable name="margin-bottom">
            <xsl:choose>
                <xsl:when test="margin-bottom"><xsl:value-of select="margin-bottom"/></xsl:when>
                <xsl:otherwise>50</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="margin-top">
            <xsl:choose>
                <xsl:when test="margin-top"><xsl:value-of select="margin-top"/></xsl:when>
                <xsl:otherwise>50</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:call-template name="button">
            <xsl:with-param name="url" select="href"/>
            <xsl:with-param name="text" select="text"/>
            <xsl:with-param name="width" select="width"/>
            <xsl:with-param name="margin-top" select="$margin-top"/>
            <xsl:with-param name="margin-bottom" select="$margin-bottom"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- 
    <link>
        <href/>
        <text/>
        <width/>
    </link>
    -->
    <xsl:template match="link">
        <xsl:call-template name="bottom-link">
            <xsl:with-param name="url" select="href"/>
            <xsl:with-param name="text" select="text"/>
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>