/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';
import Vuetify from 'vuetify';

Vue.config.productionTip = false;


import Vuex from 'vuex';

Vue.use(Vuex);
import * as FiltersStore from '../../_components/store/catalog/ProjectFiltersStore';
import * as ProjectsStore from '../../_components/store/catalog/ProjectsStore';
import * as ProjectKeywordsStore from '../../_components/store/catalog/ProjectKeywordsStore';
import * as MembersStore from '../../_components/store/members/MembersStore';

// Import Directives
import './directives';

import App from './vueserve/ProjectsCatalogModule';

window['vue-catalog-run'] = function (selector, config) {
    function _rootCategories(categories, parentCategory)
    {
        var catetegoriesMap = {};

        for (var c in categories)
        {
            var category = categories[c];

            catetegoriesMap[category.name] = parentCategory || category;

            if (categories[c].children)
            {
                var childrenCatetegoriesMap = _rootCategories(categories[c].children, catetegoriesMap[category.name]);
                catetegoriesMap = { ...catetegoriesMap, ...childrenCatetegoriesMap};
            }
        }

        return catetegoriesMap;
    }

    const store = new Vuex.Store({
      state: {
        rootCategories: _rootCategories(config.categories())
      },
      modules: {
        filters: FiltersStore,
        projects: ProjectsStore,
        members: MembersStore,
        projectKeywords: ProjectKeywordsStore
      }
    });

  return new Vue({
    store,
    render: h => h(App, {props: config}),
    vuetify: new Vuetify({
      theme: {
        themes: {
          light: {
            primary: '#9575CD'
          },
          dark: {
            primary: '#9575CD'
          },
        },
      },
    })
  }).$mount(selector);
};
