/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';

Vue.config.productionTip = false;

// Vuex
import Vuex from 'vuex';
Vue.use(Vuex);

import VueSmoothScroll from 'vue2-smooth-scroll'
Vue.use(VueSmoothScroll);

import VueSanitize from "vue-sanitize";
Vue.use(VueSanitize);

import * as TasksStore from '../../_components/store/tasks/TasksStore';
import * as TasksListStore from '../../_components/store/tasks/TasksListStore';
import * as ProjectMembersStore from '../../_components/store/project-members/ProjectMembersStore';
import * as TaskFilterStore from '../../_components/store/tasks/TasksFiltersStore';
import * as UserRightsStore from '../../_components/store/tasks/UserRightsStore';
import * as TagsStore from '../../_components/store/project-tags/TagsStore';
import * as ColorsStore from '../../_components/store/project-tags/ColorsStore';

const store = new Vuex.Store({
  modules: {
    tasks: TasksStore,
    tasksLists: TasksListStore,
    members: ProjectMembersStore,
    filters: TaskFilterStore,
    userRights: UserRightsStore,
    tags: TagsStore,
    colors: ColorsStore
  }
});

// Import Directives
import './directives';

// Vue base component
import App from './vueserve/TasksModule.vue';

// Init App
window['vue-tasks-run'] = function (selector) {
  return new Vue({
    store,
    render: h => h(App),
    /* global Vuetify */
    vuetify: new Vuetify({
      theme: {
        themes: {
          light: {
            primary: '#9575CD'
          },
          dark: {
            primary: '#9575CD'
          },
        },
      },
    }),
    created() {
      // Light theme
      this.$vuetify.theme.themes.light.primary = '#9575CD';

      // Dark theme
      this.$vuetify.theme.themes.dark.primary = '#9575CD';
    }
  }).$mount(selector);
};
