/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
const devServerBefore = process.argv[3] === 'main.standalone.js'
    ? require('../../_standalone/framework/server/middlewares')['middlewares']
    : () => {};

module.exports = {
    publicPath: '/vueserve/',
    configureWebpack: {
        externals: {
            vue: 'Vue',
            vuex: 'Vuex',
            jQuery: 'jQuery',
            AmetysFront: 'AmetysFront',
            WorkspacesUtils: 'WorkspacesUtils',
            AmetysRouter: 'AmetysRouter',
            vuetify: 'Vuetify',
            Velocity: 'Velocity',
            'vue2-perfect-scrollbar': 'Vue2PerfectScrollbar',
            'i18n': 'PLUGINS_WORKSPACES_APPLICATIONV2_WORKSPACES_I18N'
        }
    },
    devServer: {
        disableHostCheck: true,
        host: '0.0.0.0',
        port: 55550,
        before: devServerBefore
    },
    lintOnSave: true,
    css: {
        sourceMap: true
    }
};

if (process.env.NODE_ENV !== 'development')
{
    module.exports.configureWebpack.devtool = 'nosources-source-map';
}