/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.html;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;

import org.ametys.cms.transformation.html.HTMLEnhancementSource;

/**
 * This factory return files upon the HTMLEnhancementExtensionPoint.
 * <ul>
 *  <li>htmleditor2html.xsl</li>
 *  <li>html2htmleditor.xsl</li>
 * </ul> 
 */
public class HTMLSourceFactory implements SourceFactory, Serviceable
{
    private HTMLEnhancementExtensionPoint _htmlEnhancementExtensionPoint;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _htmlEnhancementExtensionPoint = (HTMLEnhancementExtensionPoint) manager.lookup(HTMLEnhancementExtensionPoint.ROLE);
    }
    
    @Override
    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException
    {
        if (location.endsWith("://html2htmleditor.xsl"))
        {
            return new HTMLEnhancementSource(location, _htmlEnhancementExtensionPoint.getHtml2htmleditorXSLT());
        }
        else if (location.endsWith("://html2html.xsl"))
        {
            return new HTMLEnhancementSource(location, _htmlEnhancementExtensionPoint.getHtml2htmlXSLT());
        }
        else if (location.endsWith("://htmleditor2html.xsl"))
        {
            return new HTMLEnhancementSource(location, _htmlEnhancementExtensionPoint.getHtmlEditor2HTMLXSLT());
        }
        else if (location.endsWith("://html2outgoingreferences.xsl"))
        {
            return new HTMLEnhancementSource(location, _htmlEnhancementExtensionPoint.getHtml2outgoingReferencesXSLT());
        }
        else
        {
            return null;
        }
    }

    @Override
    public void release(Source source)
    {
        // empty
    }

}
