/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.members;

import org.apache.avalon.framework.service.ServiceException;

import org.ametys.cms.model.properties.AbstractProperty;
import org.ametys.cms.model.properties.Property;
import org.ametys.cms.repository.Content;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link Property} for member's projects
 */
public class MemberProjectProperty extends AbstractProperty<String, Content>
{
    private ProjectManager _projectManager;
    
    public Object getValue(Content content)
    {
        UserIdentity identity = content.getValue("user");

        if (identity != null)
        {
            return _getProjectManager().getUserProjects(identity)
                    .keySet()
                    .stream()
                    .map(Project::getId)
                    .toArray(String[]::new);
        }
        else
        {
            return new String[0];
        }
    }
    
    @Override
    public boolean isMultiple()
    {
        return true;
    }

    /**
     * Retrieves the project manager
     * @return the project manager
     * @throws IllegalStateException if an error occurs
     */
    protected ProjectManager _getProjectManager() throws IllegalStateException
    {
        if (_projectManager == null)
        {
            try
            {
                _projectManager = (ProjectManager) __serviceManager.lookup(ProjectManager.ROLE);
            }
            catch (ServiceException e)
            {
                throw new IllegalStateException("Unable to lookup after the project manager component", e);
            }
        }
        return _projectManager;
    }

    @Override
    protected String _getTypeId()
    {
        return ModelItemTypeConstants.STRING_TYPE_ID;
    }
}
