/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.util;

/** 
 * Statistic column type
 */
public enum StatisticsColumnType
{
    /** String type. */
    STRING,
    /** Multilingual string */
    MULTILINGUAL_STRING
    {
        @Override
        public String getId()
        {
            return super.getId().replaceAll("_", "-");
        }
    },
    /** Rich text type. */
    RICH_TEXT
    {
        @Override
        public String getId()
        {
            return super.getId().replaceAll("_", "-");
        }
    },
    /** Date type. */
    DATE,
    /** Date time type. */
    DATETIME,
    /** Long type. */
    LONG,
    /** Double type. */
    DOUBLE,
    /** Boolean type. */
    BOOLEAN,
    /** Geocode type. */
    GEOCODE,
    /** Reference to a content. */
    CONTENT,
    /** Sub-content. */
    SUB_CONTENT,
    /** User type. */
    USER,
    /** Binary type. */
    BINARY,
    /** File type, may be a binary or a reference (symbolic link). */
    FILE,
    /** Reference type (Resources explorer / dn of a directory / ...). */
    REFERENCE;
    
    /**
     * Retrieves the type identifier
     * @return the type identifier
     */
    public String getId()
    {
        return name();
    }
}
