/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.wall;

import org.ametys.cms.model.properties.AbstractProperty;
import org.ametys.cms.model.properties.Property;
import org.ametys.cms.repository.Content;
import org.ametys.plugins.repository.tag.TaggableAmetysObject;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link Property} for pinned wall content
 *
 */
public class PinProperty extends AbstractProperty<Boolean, Content>
{
    public Object getValue(Content content)
    {
        return content instanceof TaggableAmetysObject 
                            && ((TaggableAmetysObject) content).getTags().contains(WallContentManager.WALL_CONTENT_PIN_TAG);
    }

    @Override
    protected String _getTypeId()
    {
        return ModelItemTypeConstants.BOOLEAN_TYPE_ID;
    }
}
