/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.about;

import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableWorkflowAwareContent;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.plugins.workspaces.AbstractWorkspaceModule;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.web.repository.page.ModifiablePage;
import org.ametys.web.repository.page.ModifiableZone;
import org.ametys.web.repository.page.ModifiableZoneItem;
import org.ametys.web.repository.page.Page;
import org.ametys.web.repository.page.ZoneItem;
import org.ametys.web.repository.site.Site;
import org.ametys.web.skin.Skin;
import org.ametys.web.skin.SkinTemplate;
import org.ametys.web.workflow.CreateContentFunction;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.StringUtils;

public class AboutWorkspaceModule
extends AbstractWorkspaceModule {
    public static final String ABOUT_MODULE_ID = AboutWorkspaceModule.class.getName();
    private static final String __WORKSPACES_ABOUT_NODE_NAME = "about";
    private static final int __INIT_WORKFLOW_ACTION_ID = 16;
    protected WorkflowProvider _workflowProvider;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
    }

    @Override
    public String getId() {
        return ABOUT_MODULE_ID;
    }

    @Override
    public String getModuleName() {
        return __WORKSPACES_ABOUT_NODE_NAME;
    }

    @Override
    public int getOrder() {
        return 70;
    }

    @Override
    protected String getModulePageName() {
        return __WORKSPACES_ABOUT_NODE_NAME;
    }

    @Override
    public I18nizableText getModuleTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_ABOUT_LABEL");
    }

    @Override
    public I18nizableText getModuleDescription() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_SERVICE_MODULE_ABOUT_DESCRIPTION");
    }

    @Override
    protected I18nizableText getModulePageTitle() {
        return new I18nizableText("plugin." + this._pluginName, "PLUGINS_WORKSPACES_PROJECT_WORKSPACE_PAGE_ABOUT_TITLE");
    }

    @Override
    protected String getModulePageTemplate() {
        return "project-about";
    }

    @Override
    protected void initializeModulePage(ModifiablePage page) {
        String contentTitle = StringUtils.defaultIfEmpty((String)this._i18nUtils.translate((I18nizable)this.getModulePageTitle(), page.getSitemapName()), (String)"Missing title");
        this._initializeAboutDefaultZone(page, page.getSite(), page.getSitemapName(), contentTitle);
    }

    protected void _initializeAboutDefaultZone(ModifiablePage aboutPage, Site site, String sitemapName, String title) {
        ModifiableZone defaultZone = aboutPage.createZone("default");
        ModifiableZoneItem defaultZoneItem = defaultZone.addZoneItem();
        defaultZoneItem.setType(ZoneItem.ZoneType.CONTENT);
        try {
            ModifiableWorkflowAwareContent content = this.createAboutContent(site, sitemapName, title);
            defaultZoneItem.setContent((Content)content);
            content.saveChanges();
        }
        catch (WorkflowException e) {
            this.getLogger().error("Unable to initialize the About page content for the new workspace, the about page will not be editable until the content is manually created in the BackOffice", (Throwable)e);
        }
    }

    public ModifiableWorkflowAwareContent createAboutContent(Site site, String sitemapName, String title) throws WorkflowException {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TITLE_KEY, title);
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_NAME_KEY, NameHelper.filterName((String)title));
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_TYPES_KEY, new String[]{"org.ametys.plugins.workspaces.Content.about"});
        inputs.put(org.ametys.cms.workflow.CreateContentFunction.CONTENT_LANGUAGE_KEY, sitemapName);
        inputs.put(CreateContentFunction.SITE_KEY, site.getName());
        WorkflowProvider.AmetysObjectWorkflow workflow = this._workflowProvider.getAmetysObjectWorkflow();
        workflow.initialize("workspaces-content", 16, inputs);
        Map results = (Map)inputs.get(AbstractWorkflowComponent.RESULT_MAP_KEY);
        ModifiableWorkflowAwareContent content = (ModifiableWorkflowAwareContent)results.get(Content.class.getName());
        return content;
    }

    protected void _initializeAboutPage(ModifiablePage aboutPage, Site site, String sitemapName, String title, Page parentPage) {
        Skin skin = this._skinsManager.getSkin(site.getSkinId());
        SkinTemplate template = skin.getTemplate("project-about");
        if (template != null) {
            aboutPage.setType(Page.PageType.CONTAINER);
            aboutPage.setTemplate("project-about");
            Map templateZones = template.getZones();
            if (!templateZones.containsKey("default")) {
                this.getLogger().error("A 'default' zone is mandatory in the about template!");
                return;
            }
            this._initializeAboutDefaultZone(aboutPage, site, sitemapName, title);
            aboutPage.tag("SECTION");
        } else {
            String errorMsg = String.format("The project workspace  '%s' was created with the skin '%s'  which doesn't possess the mandatory template '%s'.\nThe '%s' page of the project workspace could not be initialized.", site.getName(), site.getSkinId(), "project-about", aboutPage.getName());
            this.getLogger().error(errorMsg);
        }
    }

    @Override
    public Set<String> getAllowedEventTypes() {
        return Set.of();
    }

    @Override
    protected boolean _showActivatedStatus() {
        return false;
    }
}

