/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.activities;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.activities.Activity;
import org.ametys.plugins.repository.jcr.SimpleAmetysObject;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.notification.preferences.NotificationPreferencesHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.web.WebConstants;
import org.ametys.web.activities.notify.ActivityNotifier;
import org.ametys.web.renderingcontext.RenderingContext;
import org.ametys.web.renderingcontext.RenderingContextHandler;
import org.ametys.web.repository.site.Site;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;

public abstract class AbstractWorkspacesActivityNotifier
implements ActivityNotifier,
Serviceable,
PluginAware,
Contextualizable {
    protected RightManager _rightManager;
    protected NotificationPreferencesHelper _notificationPreferenceHelper;
    protected UserManager _userManager;
    protected ProjectManager _projectManager;
    protected I18nUtils _i18nUtils;
    protected RenderingContextHandler _renderingContextHandler;
    protected SourceResolver _srcResolver;
    protected AmetysObjectResolver _resolver;
    protected String _pluginName;
    protected Context _context;

    public void service(ServiceManager manager) throws ServiceException {
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._notificationPreferenceHelper = (NotificationPreferencesHelper)((Object)manager.lookup(NotificationPreferencesHelper.ROLE));
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._renderingContextHandler = (RenderingContextHandler)manager.lookup(RenderingContextHandler.ROLE);
        this._srcResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
    }

    public List<String> getUsersEmailToNotify(Activity activity) {
        boolean returnAll = (Boolean)Config.getInstance().getValue("runtime.mail.massive.sending");
        AmetysObject aObject = this.getTargetAmetysObject(activity);
        Set readAccessUsers = this._rightManager.getReadAccessAllowedUsers((Object)aObject).resolveAllowedUsers(returnAll);
        return readAccessUsers.stream().filter(userId -> this._notificationPreferenceHelper.askedToBeNotified((UserIdentity)userId, (String)activity.getValue("projectName"), NotificationPreferencesHelper.Frequency.EACH)).map(arg_0 -> ((UserManager)this._userManager).getUser(arg_0)).filter(Objects::nonNull).map(User::getEmail).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
    }

    public abstract AmetysObject getTargetAmetysObject(Activity var1);

    public String getMailSubject(Activity activity) {
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        Site site = project.getSite();
        String lang = site.getSitemaps().stream().findFirst().map(SimpleAmetysObject::getName).orElse(null);
        return this._i18nUtils.translate((I18nizable)new I18nizableText("plugin." + this._pluginName, this._getSubjectI18nKey(activity), this.getSubjectI18nParams(activity)), lang);
    }

    protected String _getSubjectI18nKey(Activity activity) {
        return "PROJECT_MAIL_NOTIFICATION_SUBJECT_" + StringUtils.replaceChars((String)activity.getEventType().toUpperCase(), (char)'.', (char)'_');
    }

    public List<String> getSubjectI18nParams(Activity activity) {
        ArrayList<String> i18nparams = new ArrayList<String>();
        i18nparams.add((String)activity.getValue("projectTitle"));
        return i18nparams;
    }

    public String getMailTextBody(Activity activity) {
        return null;
    }

    public String getMailHtmlBody(Activity activity) {
        String mailBody;
        String projectName = (String)activity.getValue("projectName");
        Project project = this._projectManager.getProject(projectName);
        Site site = project.getSite();
        String lang = site.getSitemaps().stream().findFirst().map(SimpleAmetysObject::getName).orElse(null);
        Source source = null;
        RenderingContext currentContext = this._renderingContextHandler.getRenderingContext();
        try {
            this._renderingContextHandler.setRenderingContext(RenderingContext.FRONT);
            Request request = ContextHelper.getRequest((Context)this._context);
            request.setAttribute("lang", (Object)lang);
            request.setAttribute("forceAbsoluteUrl", (Object)true);
            request.setAttribute(WebConstants.REQUEST_ATTR_SITE, (Object)site);
            request.setAttribute("site", (Object)site.getName());
            request.setAttribute("skin", (Object)site.getSkinId());
            source = this._srcResolver.resolveURI(this.getMailBodyURI(activity), null, Map.of("activity", activity));
            try (InputStream is = source.getInputStream();){
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                SourceUtil.copy((InputStream)is, (OutputStream)bos);
                mailBody = bos.toString("UTF-8");
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Failed to create mail body", e);
            }
            catch (Throwable throwable) {
                this._renderingContextHandler.setRenderingContext(currentContext);
                if (source != null) {
                    this._srcResolver.release(source);
                }
                throw throwable;
            }
        }
        this._renderingContextHandler.setRenderingContext(currentContext);
        if (source != null) {
            this._srcResolver.release(source);
        }
        return mailBody;
    }

    public abstract String getMailBodyURI(Activity var1);
}

