/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.calendars.resources;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ametys.core.observation.Event;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.ModifiableExplorerNode;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.messagingconnector.EventRecurrenceTypeEnum;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.workspaces.calendars.AbstractCalendarDAO;
import org.ametys.plugins.workspaces.calendars.Calendar;
import org.ametys.plugins.workspaces.calendars.CalendarWorkspaceModule;
import org.ametys.plugins.workspaces.calendars.events.CalendarEvent;
import org.ametys.plugins.workspaces.calendars.events.CalendarEventOccurrence;
import org.ametys.plugins.workspaces.calendars.events.ModifiableCalendarEvent;
import org.ametys.plugins.workspaces.calendars.helper.RecurrentEventHelper;
import org.ametys.plugins.workspaces.calendars.jcr.JCRCalendarResource;
import org.ametys.plugins.workspaces.calendars.resources.CalendarResource;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.IllegalClassException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.Text;

public class CalendarResourceDAO
extends AbstractCalendarDAO {
    public static final String ROLE = CalendarResourceDAO.class.getName();

    @Callable
    public Map<String, Object> deleteResource(String id) throws IllegalAccessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        assert (id != null);
        AmetysObject object = this._resolver.resolveById(id);
        if (!(object instanceof CalendarResource)) {
            throw new IllegalClassException(CalendarResource.class, object.getClass());
        }
        CalendarResource resource = (CalendarResource)object;
        ModifiableExplorerNode resourcesRoot = (ModifiableExplorerNode)resource.getParent();
        this._explorerResourcesDAO.checkUserRight((AmetysObject)resourcesRoot, "Plugins_Workspaces_Handle_Resource");
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)resource)) {
            this.getLogger().warn("User '" + this._currentUserProvider.getUser() + "' try to delete resource'" + object.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        String parentId = resourcesRoot.getId();
        String name = resource.getName();
        String path = resource.getPath();
        resource.remove();
        resourcesRoot.saveChanges();
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        Project project = this._getProject();
        AmetysObjectIterable<Calendar> calendars = calendarModule.getCalendars(project);
        if (calendars != null) {
            for (Calendar calendar : calendars) {
                this._removeResource(calendar, id, calendarModule.getCalendarsRoot(project, true));
            }
        }
        Calendar resourceCalendar = calendarModule.getResourceCalendar(this._getProject());
        this._removeResource(resourceCalendar, id, calendarModule.getResourceCalendarRoot(project, true));
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", id);
        eventParams.put("object.parent", parentId);
        eventParams.put("object.name", name);
        eventParams.put("object.path", path);
        this._observationManager.notify(new Event("calendar.resource.deleted", this._currentUserProvider.getUser(), eventParams));
        result.put("id", id);
        result.put("parentId", parentId);
        return result;
    }

    private void _removeResource(Calendar calendar, String id, ModifiableResourceCollection modifiableResourceCollection) {
        boolean saveChanges = false;
        for (AmetysObject child : calendar.getChildren()) {
            ModifiableCalendarEvent event;
            List<String> resourceIds;
            if (!(child instanceof ModifiableCalendarEvent) || !(resourceIds = (event = (ModifiableCalendarEvent)child).getResources()).contains(id)) continue;
            ArrayList<String> resourcesWithoutDeletedResource = new ArrayList<String>(resourceIds);
            resourcesWithoutDeletedResource.remove(id);
            event.setResources(resourcesWithoutDeletedResource);
            saveChanges = true;
        }
        if (saveChanges) {
            modifiableResourceCollection.saveChanges();
        }
    }

    protected ModifiableTraversableAmetysObject _getCalendarResourcesRoot(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        return calendarModule.getCalendarResourcesRoot(project, true);
    }

    @Callable
    public List<Map<String, Object>> getResources() throws IllegalAccessException {
        ArrayList<Map<String, Object>> resourcesInfo = new ArrayList<Map<String, Object>>();
        Project project = this._getProject();
        for (CalendarResource resource : this.getProjectResources(project)) {
            resourcesInfo.add(this.getCalendarResourceData(resource));
        }
        return resourcesInfo;
    }

    public List<CalendarResource> getProjectResources(Project project) {
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        ModifiableResourceCollection resourcesRoot = calendarModule.getCalendarResourcesRoot(project, true);
        return resourcesRoot.getChildren().stream().filter(CalendarResource.class::isInstance).map(CalendarResource.class::cast).collect(Collectors.toList());
    }

    public Map<String, Object> getCalendarResourceData(CalendarResource calendarResource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("id", calendarResource.getId());
        result.put("title", Text.unescapeIllegalJcrChars((String)calendarResource.getTitle()));
        result.put("icon", calendarResource.getIcon());
        result.put("instructions", calendarResource.getInstructions());
        return result;
    }

    @Callable
    public Map<String, Object> addResource(String title, String icon, String instructions, boolean renameIfExists) throws IllegalAccessException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String originalName = Text.escapeIllegalJcrChars((String)title);
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        ModifiableResourceCollection resourcesRoot = calendarModule.getCalendarResourcesRoot(this._getProject(), true);
        this._explorerResourcesDAO.checkUserRight((AmetysObject)resourcesRoot, "Plugins_Workspaces_Handle_Resource");
        if (BooleanUtils.isNotTrue((Boolean)renameIfExists) && resourcesRoot.hasChild(originalName)) {
            this.getLogger().warn("Cannot create the calendar with name '" + originalName + "', an object with same name already exists.");
            result.put("message", "already-exist");
            return result;
        }
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)resourcesRoot)) {
            this.getLogger().warn("User '" + this._currentUserProvider.getUser() + "' try to modify the object '" + resourcesRoot.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        int index = 2;
        Object name = originalName;
        while (resourcesRoot.hasChild((String)name)) {
            name = originalName + " (" + index + ")";
            ++index;
        }
        JCRCalendarResource resource = (JCRCalendarResource)resourcesRoot.createChild((String)name, "ametys:calendar-resource");
        resource.setTitle(title);
        resource.setIcon(icon);
        resource.setInstructions(instructions);
        resourcesRoot.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", resource.getId());
        eventParams.put("object.parent", resourcesRoot.getId());
        eventParams.put("object.name", title);
        eventParams.put("object.path", resource.getPath());
        this._observationManager.notify(new Event("calendar.resource.created", this._currentUserProvider.getUser(), eventParams));
        result.put("id", resource.getId());
        result.put("title", Text.unescapeIllegalJcrChars((String)name));
        result.put("icon", resource.getIcon());
        result.put("instructions", resource.getInstructions());
        return result;
    }

    @Callable
    public Map<String, Object> editResource(String id, String title, String icon, String instructions) throws IllegalAccessException {
        AmetysObject object = this._resolver.resolveById(id);
        if (!(object instanceof CalendarResource)) {
            throw new IllegalClassException(CalendarResource.class, object.getClass());
        }
        CalendarResource resource = (CalendarResource)object;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String name = Text.escapeIllegalJcrChars((String)title);
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        ModifiableResourceCollection resourcesRoot = calendarModule.getCalendarResourcesRoot(this._getProject(), true);
        this._explorerResourcesDAO.checkUserRight((AmetysObject)resourcesRoot, "Plugins_Workspaces_Handle_Resource");
        if (!this._explorerResourcesDAO.checkLock((AmetysObject)resourcesRoot)) {
            this.getLogger().warn("User '" + this._currentUserProvider.getUser() + "' try to modify the object '" + resourcesRoot.getName() + "' but it is locked by another user");
            result.put("message", "locked");
            return result;
        }
        resource.setTitle(name);
        resource.setIcon(icon);
        resource.setInstructions(instructions);
        resourcesRoot.saveChanges();
        HashMap<String, String> eventParams = new HashMap<String, String>();
        eventParams.put("object.id", resource.getId());
        eventParams.put("object.parent", resourcesRoot.getId());
        eventParams.put("object.name", name);
        eventParams.put("object.path", resource.getPath());
        this._observationManager.notify(new Event("calendar.resource.updated", this._currentUserProvider.getUser(), eventParams));
        result.put("id", resource.getId());
        result.put("title", Text.unescapeIllegalJcrChars((String)name));
        result.put("icon", resource.getIcon());
        result.put("instructions", resource.getInstructions());
        return result;
    }

    @Callable
    public List<Map<String, Object>> loadResourcesWithAvailability(String eventId, String startDateAsStr, String endDateAsStr, String eventStartDateAsStr, String eventEndDateAsStr, String recurrenceType, boolean isFullDay, String originalOccurrenceStartAsStr, String zoneIdAsString) {
        ZoneId zoneId;
        String projectName = this._getProjectName();
        EventRecurrenceTypeEnum recurrenceEnum = EventRecurrenceTypeEnum.valueOf((String)recurrenceType);
        CalendarEvent event = StringUtils.isNotEmpty((CharSequence)eventId) ? (CalendarEvent)this._resolver.resolveById(eventId) : null;
        Project project = this._projectManager.getProject(projectName);
        ArrayList<Map<String, Object>> resourcesInfo = new ArrayList<Map<String, Object>>();
        HashSet<String> collideEventResources = new HashSet<String>();
        ZonedDateTime startDate = DateUtils.parseZonedDateTime((String)startDateAsStr);
        ZonedDateTime eventStartDate = DateUtils.parseZonedDateTime((String)eventStartDateAsStr);
        ZonedDateTime eventEndDate = DateUtils.parseZonedDateTime((String)eventEndDateAsStr);
        ZonedDateTime originalOccurrenceStartDate = DateUtils.parseZonedDateTime((String)originalOccurrenceStartAsStr);
        ZonedDateTime endDate = DateUtils.parseZonedDateTime((String)endDateAsStr);
        long diffInSeconds = ChronoUnit.SECONDS.between(eventStartDate, eventEndDate);
        List<ZonedDateTime> occurencesfromDAO = RecurrentEventHelper.getOccurrences(startDate, endDate, eventStartDate, originalOccurrenceStartDate, recurrenceEnum, event != null ? event.getExcludedOccurences() : new ArrayList<ZonedDateTime>(), zoneId = ZoneId.of(zoneIdAsString), endDate);
        if (occurencesfromDAO.size() > 0) {
            ZonedDateTime newStartDate = occurencesfromDAO.get(0);
            ZonedDateTime newEndDate = occurencesfromDAO.get(occurencesfromDAO.size() - 1).plusSeconds(diffInSeconds);
            List<CalendarEvent> events = this._getEvents(newStartDate, newEndDate);
            for (CalendarEvent calendarEvent : events) {
                if (calendarEvent.getResources().isEmpty() || calendarEvent.getId().equals(eventId) || !this._eventCollide(calendarEvent, newStartDate, newEndDate, occurencesfromDAO, diffInSeconds, isFullDay)) continue;
                collideEventResources.addAll(calendarEvent.getResources());
            }
        }
        for (CalendarResource resource : this.getProjectResources(project)) {
            Map<String, Object> resourceMap = this.getCalendarResourceData(resource);
            resourceMap.put("available", !collideEventResources.contains(resource.getId()));
            resourcesInfo.add(resourceMap);
        }
        return resourcesInfo;
    }

    private boolean _eventCollide(CalendarEvent calendarEvent, ZonedDateTime startDate, ZonedDateTime endDate, List<ZonedDateTime> occurencesfromDAO, long diffInSeconds, boolean isFullDay) {
        ZonedDateTime firstDateCalendar;
        Optional<CalendarEventOccurrence> firstOccurrence = calendarEvent.getFirstOccurrence(isFullDay ? startDate : startDate.truncatedTo(ChronoUnit.DAYS));
        if (firstOccurrence.isEmpty()) {
            return false;
        }
        List<ZonedDateTime> excludedOccurences = calendarEvent.getExcludedOccurences();
        if (!excludedOccurences.contains(firstDateCalendar = firstOccurrence.get().getStartDate()) && !this._isAvailable(firstOccurrence.get(), occurencesfromDAO, diffInSeconds, isFullDay)) {
            return true;
        }
        Optional<CalendarEventOccurrence> nextOccurrence = calendarEvent.getNextOccurrence(firstOccurrence.get());
        while (nextOccurrence.isPresent() && nextOccurrence.get().before(endDate)) {
            ZonedDateTime nextDateCalendar = nextOccurrence.get().getStartDate();
            if (!excludedOccurences.contains(nextDateCalendar) && !this._isAvailable(firstOccurrence.get(), occurencesfromDAO, diffInSeconds, isFullDay)) {
                return true;
            }
            nextOccurrence = calendarEvent.getNextOccurrence(nextOccurrence.get());
        }
        return false;
    }

    protected List<CalendarEvent> _getEvents(ZonedDateTime startDate, ZonedDateTime endDate) {
        CalendarWorkspaceModule calendarModule = (CalendarWorkspaceModule)this._workspaceModuleEP.getModule(CalendarWorkspaceModule.CALENDAR_MODULE_ID);
        Project project = this._getProject();
        AmetysObjectIterable<Calendar> calendars = calendarModule.getCalendars(project);
        ArrayList<CalendarEvent> eventList = new ArrayList<CalendarEvent>();
        if (calendars != null) {
            for (Calendar calendar : calendars) {
                if (!calendarModule.canView(calendar)) continue;
                for (Map.Entry<CalendarEvent, List<CalendarEventOccurrence>> entry : calendar.getEvents(startDate, endDate).entrySet()) {
                    CalendarEvent event = entry.getKey();
                    eventList.add(event);
                }
            }
        }
        Calendar resourceCalendar = calendarModule.getResourceCalendar(this._getProject());
        for (Map.Entry<CalendarEvent, List<CalendarEventOccurrence>> entry : resourceCalendar.getEvents(startDate, endDate).entrySet()) {
            CalendarEvent event = entry.getKey();
            eventList.add(event);
        }
        return eventList;
    }

    private boolean _isAvailable(CalendarEventOccurrence eventOccurrence, List<ZonedDateTime> occurencesfromDAO, long diffInSeconds, boolean isFullDay) {
        ZonedDateTime occurrenceStartDate = eventOccurrence.getStartDate();
        ZonedDateTime occurrenceEndDate = eventOccurrence.getEndDate();
        if (eventOccurrence.isFullDay()) {
            occurrenceEndDate = occurrenceEndDate.plusDays(1L);
        }
        Iterator<ZonedDateTime> iterator = occurencesfromDAO.iterator();
        while (iterator.hasNext()) {
            ZonedDateTime occurenceDate;
            ZonedDateTime startDateEvent = occurenceDate = iterator.next();
            ZonedDateTime endDateEvent = occurenceDate.plusSeconds(diffInSeconds);
            if (isFullDay) {
                // empty if block
            }
            if (!startDateEvent.isBefore(occurrenceEndDate) || !occurrenceStartDate.isBefore(endDateEvent)) continue;
            return false;
        }
        return true;
    }
}

