/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.chat;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.CryptoHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.userdirectory.UserDirectoryHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.codec.digest.Sha2Crypt;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.poi.util.IOUtils;
import org.apache.tika.Tika;

public class ChatHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = ChatHelper.class.getName();
    private static final String __USERPREF_PREF_PASSWORD = "workspaces.chat-connector-password";
    private static final String __USERPREF_PREF_TOKEN = "workspaces.chat-connector-token";
    private static final String __USERPREF_PREF_ID = "workspaces.chat-connector-id";
    private static final String __USERPREF_CONTEXT = "/workspaces.chat-connector";
    private static final String CONFIG_ADMIN_ID = "workspaces.chat.rocket.admin.id";
    private static final String CONFIG_ADMIN_TOKEN = "workspaces.chat.rocket.admin.token";
    private static final String CONFIG_URL = "workspaces.chat.rocket.url";
    protected JSONUtils _jsonUtils;
    protected UserManager _userManager;
    protected UserPreferencesManager _userPreferencesManager;
    protected CryptoHelper _cryptoHelper;
    protected CurrentUserProvider _currentUserProvider;
    private SourceResolver _sourceResolver;
    private UserDirectoryHelper _userDirectoryHelper;
    private Context _context;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._userPreferencesManager = (UserPreferencesManager)manager.lookup(UserPreferencesManager.ROLE);
        this._cryptoHelper = (CryptoHelper)manager.lookup("org.ametys.plugins.workspaces.chat.cryptoHelper");
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._userDirectoryHelper = (UserDirectoryHelper)manager.lookup(UserDirectoryHelper.ROLE);
    }

    private Map<String, Object> _doGet(String api, Map<String, String> parameters) throws IOException {
        return this._doGet(api, parameters, (String)Config.getInstance().getValue(CONFIG_ADMIN_TOKEN), (String)Config.getInstance().getValue(CONFIG_ADMIN_ID));
    }

    private Map<String, Object> _doGet(String api, Map<String, String> parameters, String authToken, String userId) throws IOException {
        String path = Config.getInstance().getValue(CONFIG_URL) + "/api/" + api;
        String uri = URIUtils.encodeURI((String)path, parameters);
        HttpGet request = new HttpGet(uri);
        request.setHeader("Content-Type", "application/json");
        return this._execRequest((HttpUriRequest)request, authToken, userId);
    }

    private Map<String, Object> _doPOST(String api, Map<String, Object> parameters) throws IOException {
        return this._doPOST(api, parameters, (String)Config.getInstance().getValue(CONFIG_ADMIN_TOKEN), (String)Config.getInstance().getValue(CONFIG_ADMIN_ID));
    }

    private Map<String, Object> _doPOST(String api, Map<String, Object> parameters, String authToken, String userId) throws IOException {
        String path = Config.getInstance().getValue(CONFIG_URL) + "/api/" + api;
        HttpPost request = new HttpPost(path);
        String json = this._jsonUtils.convertObjectToJson(parameters);
        request.setEntity((HttpEntity)new StringEntity(json, ContentType.create((String)"application/json", (Charset)StandardCharsets.UTF_8)));
        request.setHeader("Content-Type", "application/json");
        return this._execRequest((HttpUriRequest)request, authToken, userId);
    }

    private Map<String, Object> _doMultipartPOST(String api, Map<String, Object> parameters) throws IOException {
        return this._doMultipartPOST(api, parameters, (String)Config.getInstance().getValue(CONFIG_ADMIN_TOKEN), (String)Config.getInstance().getValue(CONFIG_ADMIN_ID));
    }

    private Map<String, Object> _doMultipartPOST(String api, Map<String, Object> parameters, String authToken, String userId) throws IOException {
        String path = Config.getInstance().getValue(CONFIG_URL) + "/api/" + api;
        HttpPost request = new HttpPost(path);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.RFC6532);
        for (Map.Entry<String, Object> p : parameters.entrySet()) {
            if (p.getValue() instanceof String) {
                builder.addTextBody(p.getKey(), (String)p.getValue(), ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
                continue;
            }
            Object object = p.getValue();
            if (object instanceof InputStream) {
                InputStream is = (InputStream)object;
                byte[] imageAsBytes = IOUtils.toByteArray((InputStream)is);
                ByteArrayInputStream bis = new ByteArrayInputStream(imageAsBytes);
                Tika tika = new Tika();
                String mimeType = tika.detect(imageAsBytes);
                builder.addBinaryBody(p.getKey(), (InputStream)bis, ContentType.create((String)mimeType), p.getKey());
                continue;
            }
            throw new UnsupportedOperationException("Cannot post the type " + p.getValue().getClass().getName() + " for parameter " + p.getKey());
        }
        HttpEntity multipart = builder.build();
        request.setEntity(multipart);
        return this._execRequest((HttpUriRequest)request, authToken, userId);
    }

    private boolean _isPOSTSucessful(String api, Map<String, Object> parameters) throws IOException {
        return this._isOperationSuccessful(this._doPOST(api, parameters));
    }

    private Map<String, Object> _execRequest(HttpUriRequest request, String authToken, String userId) throws IOException {
        request.setHeader("X-Auth-Token", authToken);
        request.setHeader("X-User-Id", userId);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            Map map;
            block12: {
                CloseableHttpResponse response = httpClient.execute(request);
                try {
                    Map convertJsonToMap;
                    map = convertJsonToMap = this._jsonUtils.convertJsonToMap(EntityUtils.toString((HttpEntity)response.getEntity()));
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return map;
        }
    }

    private String _getError(Map<String, Object> info) {
        if (info.containsKey("error")) {
            return (String)info.get("error");
        }
        if (info.containsKey("message")) {
            return (String)info.get("message");
        }
        return "";
    }

    public Map<String, Object> getRoom(String roomName, boolean create) throws IOException {
        Map<String, Object> groupInfo = this._doGet("v1/groups.info", Map.of("roomName", roomName));
        if (!this._isOperationSuccessful(groupInfo)) {
            if (create) {
                groupInfo = this._doPOST("v1/groups.create", Map.of("name", roomName));
                if (!this._isOperationSuccessful(groupInfo)) {
                    throw new IOException("Could not create room " + roomName + ", because " + this._getError(groupInfo));
                }
            } else {
                return null;
            }
        }
        return (Map)groupInfo.get("group");
    }

    public void deleteRoom(String roomName) throws IOException {
        Map<String, Object> deleteInfos;
        if (this.getRoom(roomName, false) != null && !this._isOperationSuccessful(deleteInfos = this._doPOST("v1/groups.delete", Map.of("roomName", roomName)))) {
            throw new IOException("Could not delete room " + roomName + ", because " + this._getError(deleteInfos));
        }
    }

    public Map<String, Object> getUser(UserIdentity userIdentity, boolean create) throws IOException, UserPreferencesException {
        User user = this._userManager.getUser(userIdentity);
        if (user == null) {
            throw new IllegalStateException("Cannot create user in Rocket.Chat for unexisting user " + UserIdentity.userIdentityToString((UserIdentity)userIdentity));
        }
        Map<String, Object> userInfo = this._doGet("v1/users.info", Map.of("username", ChatHelper.userIdentitytoUserName(userIdentity)));
        if (!this._isOperationSuccessful(userInfo)) {
            if (create) {
                Map<String, String> ametysUserInfo = this._getAmetysUserInfo(user);
                String userName = ametysUserInfo.get("userName");
                String userEmail = ametysUserInfo.get("userEmail");
                userInfo = this._doPOST("v1/users.create", Map.of("username", ChatHelper.userIdentitytoUserName(userIdentity), "email", userEmail, "name", userName, "verified", true, "password", this._getUserPassword(userIdentity)));
                if (!this._isOperationSuccessful(userInfo)) {
                    throw new IllegalStateException("Cannot create user in Rocket.Chat for " + UserIdentity.userIdentityToString((UserIdentity)userIdentity) + ": " + this._getError(userInfo));
                }
                this.getLogger().debug("User " + UserIdentity.userIdentityToString((UserIdentity)userIdentity) + " created on the chat server");
                this._updateAvatar(userIdentity);
            } else {
                return null;
            }
        }
        Map userMap = (Map)userInfo.get("user");
        this._userPreferencesManager.addUserPreference(userIdentity, __USERPREF_CONTEXT, Collections.emptyMap(), __USERPREF_PREF_ID, (String)userMap.get("_id"));
        return userMap;
    }

    private Map<String, String> _getAmetysUserInfo(User user) {
        String userName = user.getFullName();
        String userEmail = user.getEmail();
        Content userContent = this._userDirectoryHelper.getUserContent(user.getIdentity(), null);
        if (userContent != null) {
            userName = (String)StringUtils.defaultIfBlank((CharSequence)StringUtils.join((Object[])new String[]{(String)userContent.getValue("firstname"), (String)userContent.getValue("lastname")}, (String)" "), (CharSequence)userName);
            userEmail = (String)StringUtils.defaultIfBlank((CharSequence)((String)userContent.getValue("email")), (CharSequence)userEmail);
        }
        return Map.of("userName", userName, "userEmail", userEmail);
    }

    public void updateUserInfos(UserIdentity userIdentity, boolean changePassword) throws IOException, UserPreferencesException, InterruptedException {
        Map<String, Object> updateInfos;
        User user = this._userManager.getUser(userIdentity);
        if (user == null) {
            throw new IllegalStateException("Cannot update user in Rocket.Chat for unexisting user " + UserIdentity.userIdentityToString((UserIdentity)userIdentity));
        }
        Map<String, String> ametysUserInfo = this._getAmetysUserInfo(user);
        String userName = ametysUserInfo.get("userName");
        String userEmail = ametysUserInfo.get("userEmail");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("email", userEmail);
        data.put("name", userName);
        if (changePassword) {
            data.put("password", this._getUserPassword(userIdentity));
        }
        if (!this._isOperationSuccessful(updateInfos = this._doPOST("v1/users.update", Map.of("userId", this._getUserId(userIdentity), "data", data)))) {
            throw new IOException("Cannot update user " + UserIdentity.userIdentityToString((UserIdentity)userIdentity) + " on chat server: " + this._getError(updateInfos));
        }
        if (changePassword) {
            Thread.sleep(1000L);
        }
        this._updateAvatar(userIdentity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateAvatar(UserIdentity user) {
        Request request = ContextHelper.getRequest((Context)this._context);
        request.setAttribute("Runtime:InternalAllowedRequest", (Object)true);
        String oldPluginName = (String)request.getAttribute("pluginName");
        Source src = null;
        try {
            src = this._sourceResolver.resolveURI("cocoon://_plugins/user-directory/user/" + user.getPopulationId() + "/" + user.getLogin() + "/image_64");
            try (InputStream is = src.getInputStream();){
                Map<String, Object> avatarInfo = this._doMultipartPOST("v1/users.setAvatar", Map.of("username", ChatHelper.userIdentitytoUserName(user), "image", is));
                if (!this._isOperationSuccessful(avatarInfo)) {
                    this.getLogger().warn("Fail to update avatar for user " + UserIdentity.userIdentityToString((UserIdentity)user) + ": " + this._getError(avatarInfo));
                }
            }
        }
        catch (Exception e) {
            try {
                this.getLogger().warn("Fail to update avatar for user " + UserIdentity.userIdentityToString((UserIdentity)user), (Throwable)e);
            }
            catch (Throwable throwable) {
                this._sourceResolver.release(src);
                request.setAttribute("pluginName", (Object)oldPluginName);
                throw throwable;
            }
            this._sourceResolver.release(src);
            request.setAttribute("pluginName", (Object)oldPluginName);
        }
        this._sourceResolver.release(src);
        request.setAttribute("pluginName", (Object)oldPluginName);
    }

    private boolean _isUserInGroup(UserIdentity userIdentity, String roomName) throws IOException {
        Map<String, Object> getMembers = this._doGet("v1/groups.members", Map.of("roomName", roomName));
        if (this._isOperationSuccessful(getMembers)) {
            List membersObject = (List)getMembers.get("members");
            for (Map map : membersObject) {
                if (!ChatHelper.userIdentitytoUserName(userIdentity).equalsIgnoreCase((String)map.get("username"))) continue;
                return true;
            }
        }
        return false;
    }

    public void addUserToRoom(UserIdentity userIdentity, String roomName) throws IOException, UserPreferencesException {
        if (!this._isUserInGroup(userIdentity, roomName)) {
            String userId;
            Map<String, Object> userInfo = this.getUser(userIdentity, true);
            Map<String, Object> groupInfo = this.getRoom(roomName, true);
            String roomId = (String)groupInfo.get("_id");
            Map<String, Object> inviteInfo = this._doPOST("v1/groups.invite", Map.of("roomId", roomId, "userId", userId = (String)userInfo.get("_id")));
            if (!this._isOperationSuccessful(inviteInfo)) {
                throw new IOException("Could not add user " + UserIdentity.userIdentityToString((UserIdentity)userIdentity) + " to room " + roomName + ": " + this._getError(inviteInfo));
            }
        }
    }

    public void removeAllUsersFromRoom(String roomName, List<UserIdentity> except) throws IOException {
        List exceptUsernames = except.stream().map(ChatHelper::userIdentitytoUserName).collect(Collectors.toList());
        Map<String, Object> groupInfo = this.getRoom(roomName, false);
        String roomId = (String)groupInfo.get("_id");
        Map<String, Object> membersInfo = this._doGet("v1/groups.members", Map.of("roomId", roomId));
        if (this._isOperationSuccessful(membersInfo)) {
            List members = (List)membersInfo.get("members");
            for (Map member : members) {
                if (exceptUsernames.contains(member.get("username"))) continue;
                this._doPOST("v1/groups.kick", Map.of("roomId", roomId, "userId", (String)member.get("_id")));
            }
        }
    }

    public boolean removeUserFromRoom(UserIdentity user, String roomName) throws IOException, UserPreferencesException {
        if (this._isUserInGroup(user, roomName)) {
            Map<String, Object> userInfo = this.getUser(user, false);
            Map<String, Object> groupInfo = this.getRoom(roomName, false);
            if (userInfo != null && groupInfo != null) {
                String roomId = (String)groupInfo.get("_id");
                String userId = (String)userInfo.get("_id");
                return this._isPOSTSucessful("v1/groups.kick", Map.of("roomId", roomId, "userId", userId));
            }
            return false;
        }
        return true;
    }

    public static String userIdentitytoUserName(UserIdentity userIdentity) {
        return UserIdentity.userIdentityToString((UserIdentity)userIdentity).replaceAll("[@# ]", "_");
    }

    private String _getUserPassword(UserIdentity userIdentity) throws UserPreferencesException {
        String cryptedPassword = this._userPreferencesManager.getUserPreferenceAsString(userIdentity, __USERPREF_CONTEXT, Collections.emptyMap(), __USERPREF_PREF_PASSWORD);
        if (!StringUtils.isBlank((CharSequence)cryptedPassword)) {
            try {
                return this._cryptoHelper.decrypt(cryptedPassword);
            }
            catch (CryptoHelper.WrongKeyException e) {
                this.getLogger().warn("Password of user {} cannot be decrypted, and thus will be reset", (Object)UserIdentity.userIdentityToString((UserIdentity)userIdentity), (Object)e);
            }
        }
        return this._generateAndStorePassword(userIdentity);
    }

    private String _getUserAuthToken(UserIdentity userIdentity) throws UserPreferencesException, IOException, InterruptedException {
        String cryptedToken = this._userPreferencesManager.getUserPreferenceAsString(userIdentity, __USERPREF_CONTEXT, Collections.emptyMap(), __USERPREF_PREF_TOKEN);
        if (!StringUtils.isBlank((CharSequence)cryptedToken)) {
            try {
                return this._cryptoHelper.decrypt(cryptedToken);
            }
            catch (CryptoHelper.WrongKeyException e) {
                this.getLogger().warn("Token of user {} cannot be decrypted, and thus will be reset", (Object)UserIdentity.userIdentityToString((UserIdentity)userIdentity), (Object)e);
            }
        }
        return this._generateAndStoreAuthToken(userIdentity, true);
    }

    private String _getUserId(UserIdentity userIdentity) throws UserPreferencesException {
        String userId = this._userPreferencesManager.getUserPreferenceAsString(userIdentity, __USERPREF_CONTEXT, Collections.emptyMap(), __USERPREF_PREF_ID);
        return userId;
    }

    private String _generateAndStorePassword(UserIdentity user) throws UserPreferencesException {
        Double random = Math.random();
        byte[] randoms = new byte[]{random.byteValue()};
        String randomPassword = Sha2Crypt.sha256Crypt((byte[])randoms);
        String cryptedPassword = this._cryptoHelper.encrypt(randomPassword);
        this._userPreferencesManager.addUserPreference(user, __USERPREF_CONTEXT, Collections.emptyMap(), __USERPREF_PREF_PASSWORD, cryptedPassword);
        return randomPassword;
    }

    private String _generateAndStoreAuthToken(UserIdentity user, boolean tryToChangePassword) throws IOException, UserPreferencesException, InterruptedException {
        Map<String, Object> loginInfo = this._doPOST("v1/login", Map.of("user", ChatHelper.userIdentitytoUserName(user), "password", this._getUserPassword(user)));
        if (this._isOperationSuccessful(loginInfo)) {
            String authToken = (String)((Map)loginInfo.get("data")).get("authToken");
            String cryptedAuthToken = this._cryptoHelper.encrypt(authToken);
            this._userPreferencesManager.addUserPreference(user, __USERPREF_CONTEXT, Collections.emptyMap(), __USERPREF_PREF_TOKEN, cryptedAuthToken);
            return authToken;
        }
        if (tryToChangePassword) {
            this.updateUserInfos(user, true);
            return this._generateAndStoreAuthToken(user, false);
        }
        throw new IOException("Could not log user " + UserIdentity.userIdentityToString((UserIdentity)user) + " into chat " + this._getError(loginInfo));
    }

    private String _getUserStatus(UserIdentity user, String authToken, String userId) throws IOException {
        Map<String, Object> statusInfo = this._doGet("v1/users.getStatus", Map.of("user", ChatHelper.userIdentitytoUserName(user)), authToken, userId);
        if (this._isOperationSuccessful(statusInfo)) {
            return (String)statusInfo.get("status");
        }
        return null;
    }

    protected boolean _isOperationSuccessful(Map<String, Object> result) {
        Boolean success = false;
        if (result != null) {
            Object successObj = result.get("success");
            if (successObj instanceof Boolean) {
                success = (Boolean)successObj;
            } else if (successObj instanceof String) {
                success = "true".equalsIgnoreCase((String)successObj);
            } else {
                Object statusObj = result.get("status");
                if (statusObj instanceof String) {
                    success = "success".equalsIgnoreCase((String)statusObj);
                }
            }
        }
        return success;
    }

    @Callable
    public Map<String, Object> login(String roomName) throws IOException, UserPreferencesException, InterruptedException {
        UserIdentity user = this._currentUserProvider.getUser();
        this.getUser(user, true);
        this.getRoom(roomName, true);
        this.addUserToRoom(user, roomName);
        String authToken = this._getUserAuthToken(user);
        String userId = this._getUserId(user);
        String status = this._getUserStatus(user, authToken, userId);
        if (status == null && (status = this._getUserStatus(user, authToken = this._generateAndStoreAuthToken(user, true), userId)) == null) {
            throw new IllegalStateException("Cannot get the status of user " + UserIdentity.userIdentityToString((UserIdentity)user));
        }
        return Map.of("userId", userId, "authToken", authToken, "userName", ChatHelper.userIdentitytoUserName(user), "status", status);
    }
}

