/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.cmis;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.URIUtils;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.workspaces.cmis.CmisRepository;
import org.ametys.plugins.workspaces.cmis.CmisServiceFactory;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;

public class CmisServiceImpl
extends AbstractCmisService {
    private CmisServiceFactory _factory;
    private CallContext _context;
    private CmisRepository _repository;
    private boolean _isAuthenticated;

    public CmisServiceImpl(CallContext context, CmisServiceFactory factory) {
        this._factory = factory;
        this._context = context;
        this._isAuthenticated = false;
        this._repository = new CmisRepository();
    }

    private Project authenticateAndGetProject(String encodedProjectId) {
        String decodedProjectId = URIUtils.decode((String)URIUtils.decode((String)encodedProjectId));
        Project project = this.getProject(decodedProjectId, this._factory);
        UserIdentity user = this.authenticate(this.getCallContext(), project.getName(), this._factory);
        Set grantedSites = this._factory.getSiteManager().getGrantedSites(user);
        if (user != null && grantedSites.contains(project.getName()) && this.isDocumentModuleActivated(project)) {
            return project;
        }
        throw new CmisPermissionDeniedException("Authentication process failure");
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        ArrayList<RepositoryInfo> result = new ArrayList<RepositoryInfo>();
        AmetysObjectIterable<Project> projects = this._factory.getProjectManager().getProjects();
        this.authenticate(this.getCallContext(), null, this._factory);
        UserIdentity user = this._factory.getCurrentUserProvider().getUser();
        Set grantedSites = this._factory.getSiteManager().getGrantedSites(user);
        for (Project project : projects) {
            if (user == null || !grantedSites.contains(project.getName()) || !this.isDocumentModuleActivated(project)) continue;
            result.add(this._repository.getRepositoryInfo(this.getCallContext(), project, this._factory));
        }
        return result;
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        this.authenticateAndGetProject(repositoryId);
        return this._repository.getTypeChildren(this.getCallContext(), typeId, includePropertyDefinitions, maxItems, skipCount, this._factory);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        this.authenticateAndGetProject(repositoryId);
        return this._repository.getTypeDefinition(this.getCallContext(), typeId, this._factory);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        String decodedFolderId = URIUtils.decode((String)URIUtils.decode((String)folderId));
        return this._repository.getChildren(this.getCallContext(), decodedFolderId, project, renditionFilter, includeAllowableActions, includePathSegment, maxItems, skipCount, (ObjectInfoHandler)this, this._factory);
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        String decodedObjectId = URIUtils.decode((String)URIUtils.decode((String)objectId));
        return this._repository.getObjectParents(this.getCallContext(), decodedObjectId, project, renditionFilter, includeAllowableActions, includeRelativePathSegment, (ObjectInfoHandler)this, this._factory);
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        String decodedObjectId = URIUtils.decode((String)URIUtils.decode((String)objectId));
        return this._repository.getObject(this.getCallContext(), project, decodedObjectId, null, renditionFilter, includeAllowableActions, includeAcl, (ObjectInfoHandler)this, this._factory);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        this.authenticateAndGetProject(repositoryId);
        String decodedObjectId = URIUtils.decode((String)URIUtils.decode((String)objectId));
        return this._repository.getContentStream(this.getCallContext(), decodedObjectId, offset, length, this._factory);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        return this._repository.getObjectByPath(this.getCallContext(), project, path, renditionFilter, includeAllowableActions, includeAcl, (ObjectInfoHandler)this, this._factory);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        String decodedFolderId = URIUtils.decode((String)URIUtils.decode((String)folderId));
        return this._repository.createFolder(this.getCallContext(), properties, project, decodedFolderId, this._factory);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        String decodedFolderId = URIUtils.decode((String)URIUtils.decode((String)folderId));
        return this._repository.createDocument(this.getCallContext(), properties, project, decodedFolderId, contentStream, versioningState, this._factory);
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.authenticateAndGetProject(repositoryId);
        String decodedObjectId = URIUtils.decode((String)URIUtils.decode((String)objectId));
        this._repository.deleteObject(this.getCallContext(), decodedObjectId, this._factory);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        String decodedFolderId = URIUtils.decode((String)URIUtils.decode((String)folderId));
        return this._repository.deleteTree(this.getCallContext(), project, decodedFolderId, this._factory);
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        String decodedFolderId = URIUtils.decode((String)URIUtils.decode((String)folderId));
        return this._repository.getFolderParent(this.getCallContext(), project, decodedFolderId, filter, (ObjectInfoHandler)this, this._factory);
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        this._repository.updateProperties(this.getCallContext(), project, objectId, properties, (ObjectInfoHandler)this, this._factory);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        this._repository.changeContentStream(this.getCallContext(), project, objectId, overwriteFlag, contentStream, false, this._factory);
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        Project project = this.authenticateAndGetProject(repositoryId);
        this._repository.moveObject(this.getCallContext(), project, objectId, targetFolderId, (ObjectInfoHandler)this, this._factory);
    }

    private UserIdentity authenticate(CallContext context, String projectName, CmisServiceFactory factory) {
        if (this._isAuthenticated) {
            return this._factory.getCurrentUserProvider().getUser();
        }
        if (context == null) {
            throw new CmisPermissionDeniedException("No user context!");
        }
        String userName = context.getUsername();
        String password = context.getPassword();
        Source source = null;
        try {
            if (projectName == null) {
                source = factory.getSourceResolver().resolveURI("cocoon:/_authenticate?token=" + URIUtils.encodeParameter((String)password));
            } else {
                HttpServletRequest request = (HttpServletRequest)context.get("httpServletRequest");
                request.setAttribute("projectName", (Object)projectName);
                source = factory.getSourceResolver().resolveURI("cocoon:/_authenticate/" + projectName + "?token=" + URIUtils.encodeParameter((String)password));
            }
            try (InputStream is = source.getInputStream();){
                IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            try {
                throw new CmisPermissionDeniedException("Authentication process failure", (Throwable)e);
            }
            catch (Throwable throwable) {
                factory.getSourceResolver().release(source);
                throw throwable;
            }
        }
        factory.getSourceResolver().release(source);
        UserIdentity user = this._factory.getCurrentUserProvider().getUser();
        if (user == null || !user.getLogin().equals(userName)) {
            throw new CmisPermissionDeniedException("Authentication process failure");
        }
        this._isAuthenticated = true;
        return user;
    }

    private Project getProject(String projectId, CmisServiceFactory factory) {
        AmetysObject repositoryAmetysObject = factory.getResolver().resolveById(projectId);
        if (repositoryAmetysObject instanceof Project) {
            return (Project)repositoryAmetysObject;
        }
        throw new CmisInvalidArgumentException("Project is not valid.");
    }

    public void setCallContext(CallContext context) {
        this._context = context;
    }

    public CallContext getCallContext() {
        return this._context;
    }

    private boolean isDocumentModuleActivated(Project project) {
        return this._factory.getProjectManager().isModuleActivated(project, this._factory.getDocumentModule().getId());
    }
}

