/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.dav;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockManager;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResource;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.actions.AddOrUpdateResourceHelper;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.lock.LockAwareAmetysObject;
import org.ametys.plugins.repository.lock.LockHelper;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;

public class WebdavPutAction
extends AbstractAction
implements Serviceable {
    protected CurrentUserProvider _currentUserProvider;
    protected ObservationManager _observationManager;
    private AmetysObjectResolver _resolver;
    private AddOrUpdateResourceHelper _addOrUpdateResourceHelper;

    public void service(ServiceManager smanager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
        this._observationManager = (ObservationManager)smanager.lookup(ObservationManager.ROLE);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._addOrUpdateResourceHelper = (AddOrUpdateResourceHelper)smanager.lookup(AddOrUpdateResourceHelper.ROLE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        ModifiableResource resource = (ModifiableResource)request.getAttribute("resource");
        if (resource != null) {
            Node node;
            if (resource.isLocked() && !LockHelper.isLockOwner((LockAwareAmetysObject)resource, (UserIdentity)this._currentUserProvider.getUser())) {
                HttpResponse response = (HttpResponse)ObjectModelHelper.getResponse((Map)objectModel);
                response.setStatus(423);
                return null;
            }
            if (resource instanceof JCRAmetysObject && (node = ((JCRAmetysObject)resource).getNode()).isLocked()) {
                LockManager lockManager = node.getSession().getWorkspace().getLockManager();
                Lock lock = lockManager.getLock(node.getPath());
                Node lockHolder = lock.getNode();
                lockManager.addLockToken(lockHolder.getProperty("ametys-internal:lockToken").getString());
            }
            ServletInputStream is = request.getInputStream();
            UserIdentity author = this._currentUserProvider.getUser();
            String mimeType = resource.getMimeType();
            mimeType = mimeType == null ? "application/unknown" : mimeType;
            resource.setData((InputStream)is, mimeType, new Date(), author);
            resource.saveChanges();
            this._checkpoint(resource);
            HashMap<String, String> eventParams = new HashMap<String, String>();
            eventParams.put("object.id", resource.getId());
            eventParams.put("object.name", resource.getName());
            eventParams.put("object.path", resource.getPath());
            eventParams.put("resource.path", resource.getResourcePath());
            AmetysObject parent = resource.getParent();
            if (parent != null) {
                eventParams.put("object.parent", parent.getId());
                eventParams.put("object.parent.path", parent.getPath());
            }
            this._observationManager.notify(new Event("resource.updated", this._currentUserProvider.getUser(), eventParams));
            return EMPTY_MAP;
        }
        String filePath = parameters.getParameter("path");
        int lastSlashPos = filePath.lastIndexOf(47);
        if (lastSlashPos <= 0) return EMPTY_MAP;
        String folderPath = filePath.substring(0, lastSlashPos);
        String fileName = filePath.substring(lastSlashPos + 1);
        Project project = (Project)((Object)request.getAttribute("project"));
        AmetysObject folderAmetysObject = this._resolver.resolveByPath(project.getPath() + "/ametys-internal:resources/" + folderPath);
        if (!(folderAmetysObject instanceof ModifiableResourceCollection)) {
            this.getLogger().error("User '" + this._currentUserProvider.getUser() + "' try create a ressource named '" + fileName + "' in parent '" + folderAmetysObject.getId() + "' but the parent is not a ModifiableResourceCollection");
            HttpResponse response = (HttpResponse)ObjectModelHelper.getResponse((Map)objectModel);
            response.setStatus(409);
            return EMPTY_MAP;
        }
        ModifiableResourceCollection folder = (ModifiableResourceCollection)folderAmetysObject;
        this._addOrUpdateResourceHelper.checkAddResourceRight(folder);
        ServletInputStream is = request.getInputStream();
        AddOrUpdateResourceHelper.ResourceOperationResult operationResult = this._addOrUpdateResourceHelper.performResourceOperation((InputStream)is, fileName, folder, AddOrUpdateResourceHelper.ResourceOperationMode.ADD);
        if (operationResult.isSuccess()) {
            resource = (ModifiableResource)operationResult.getResource();
            return EMPTY_MAP;
        }
        this.getLogger().error("User '" + this._currentUserProvider.getUser() + "' try create a ressource named '" + fileName + "' in parent '" + folder.getId() + "' but it failed with message : " + operationResult.getErrorMessage());
        HttpResponse response = (HttpResponse)ObjectModelHelper.getResponse((Map)objectModel);
        int status = 500;
        switch (operationResult.getErrorMessage()) {
            case "locked": 
            case "locked-file": {
                status = 423;
                break;
            }
            case "already-exist": {
                status = 409;
                break;
            }
            default: {
                status = 500;
            }
        }
        response.setStatus(status);
        return EMPTY_MAP;
    }

    private void _checkpoint(ModifiableResource resource) {
        if (resource instanceof VersionableAmetysObject) {
            ((VersionableAmetysObject)resource).checkpoint();
        }
    }
}

