/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.dav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObject;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.http.HttpResponse;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.compress.utils.IOUtils;
import org.xml.sax.SAXException;

public class WebdavResourceReader
extends ServiceableReader {
    public void generate() throws IOException, SAXException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        AmetysObject object = (AmetysObject)request.getAttribute("resource");
        Response response = ObjectModelHelper.getResponse((Map)this.objectModel);
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            response.setHeader("Content-Type", resource.getMimeType());
            String lastModified = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(TimeZone.getTimeZone("GMT").toZoneId()).format(DateUtils.asZonedDateTime((Date)resource.getLastModified(), (ZoneId)ZoneId.systemDefault()));
            response.setHeader("Last-Modified", lastModified);
            response.setHeader("ETag", resource.getLastModified().toString());
            String etag = request.getHeader("If-None-Match");
            if (etag != null && etag.equals(resource.getLastModified().toString())) {
                ((HttpResponse)response).setStatus(304);
                response.setHeader("Content-Length", "0");
                return;
            }
            try (InputStream is = resource.getInputStream();){
                response.setHeader("Content-Length", String.valueOf(resource.getLength()));
                IOUtils.copy((InputStream)is, (OutputStream)this.out);
            }
        }
    }
}

