/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.onlyoffice;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ametys.core.ui.Callable;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.commons.lang3.StringUtils;

public class OnlyOfficeKeyManager
extends AbstractLogEnabled
implements Component,
Initializable {
    public static final String ROLE = OnlyOfficeKeyManager.class.getName();
    private Map<String, String> _onlyOfficeKeyStorage;

    public void initialize() throws Exception {
        this._onlyOfficeKeyStorage = new ConcurrentHashMap<String, String>();
    }

    @Callable
    public synchronized String getKey(String resourceId) {
        String tokenKey = this._resourceIdToTokenKey(resourceId);
        return this._onlyOfficeKeyStorage.computeIfAbsent(tokenKey, this::createKey);
    }

    protected String createKey(String tokenKey) {
        String currentTime = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
        return tokenKey + "." + currentTime;
    }

    public void removeKey(String resourceId) {
        String tokenKey = this._resourceIdToTokenKey(resourceId);
        this._onlyOfficeKeyStorage.remove(tokenKey);
    }

    private String _resourceIdToTokenKey(String ressourceId) {
        return StringUtils.substringAfter((String)ressourceId, (String)"://");
    }
}

