/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.documents.onlyoffice;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.ametys.cms.content.indexing.solr.SolrResourceGroupedMimeTypes;
import org.ametys.core.authentication.token.AuthenticationTokenManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.documents.onlyoffice.OnlyOfficeKeyManager;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.URLSource;

public class OnlyOfficeManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = OnlyOfficeManager.class.getName();
    public static final String WORKSPACE_PATH_CACHE = "cache/workspaces";
    public static final String THUMBNAIL_FILE_PATH = "file-manager/thumbnail";
    private static final byte[] __JWT_HEADER_BYTES = "{\"alg\":\"HS256\",\"typ\":\"JWT\"}".getBytes(StandardCharsets.UTF_8);
    private static final String __JWT_HEADER_BASE64 = Base64.getUrlEncoder().withoutPadding().encodeToString(__JWT_HEADER_BYTES);
    protected AuthenticationTokenManager _tokenManager;
    protected CurrentUserProvider _currentUserProvider;
    protected AmetysObjectResolver _resolver;
    protected OnlyOfficeKeyManager _onlyOfficeKeyManager;
    protected JSONUtils _jsonUtils;
    protected SourceResolver _sourceResolver;
    private Map<String, Lock> _locks = new ConcurrentHashMap<String, Lock>();

    public void service(ServiceManager manager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._tokenManager = (AuthenticationTokenManager)manager.lookup(AuthenticationTokenManager.ROLE);
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._onlyOfficeKeyManager = (OnlyOfficeKeyManager)((Object)manager.lookup(OnlyOfficeKeyManager.ROLE));
        this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public boolean isOnlyOfficeAvailable() {
        return (Boolean)Config.getInstance().getValue("workspaces.onlyoffice.enabled", false, (Object)false);
    }

    @Callable
    public Map<String, Object> getOnlyOfficeInfo(String resourceId) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        OnlyOfficeResource resource = this._getOnlyOfficeResource(resourceId, this._currentUserProvider.getUser());
        HashMap<String, String> fileInfo = new HashMap<String, String>();
        fileInfo.put("title", resource.title());
        fileInfo.put("fileExtension", resource.fileExtension());
        fileInfo.put("key", resource.key());
        fileInfo.put("previewKey", resource.previewKey());
        fileInfo.put("urlDownload", resource.urlDownload());
        infos.put("file", fileInfo);
        infos.put("callbackUrl", resource.callbackUrl());
        return infos;
    }

    @Callable
    public String generateToken(String fileId) {
        return this._generateToken(fileId, this._currentUserProvider.getUser());
    }

    private String _generateToken(String fileId, UserIdentity user) {
        Set<String> contexts = Set.of(StringUtils.substringAfter((String)fileId, (String)"://"));
        return this._tokenManager.generateToken(user, 30000L, true, null, contexts, "onlyOfficeResponse", null);
    }

    @Callable
    public Map<String, Object> signConfiguration(String toSign) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            String token = this._signConfiguration(toSign);
            if (StringUtils.isNotBlank((CharSequence)token)) {
                result.put("signature", token);
            }
            result.put("success", "true");
            return result;
        }
        catch (GeneralSecurityException e) {
            result.put("success", "false");
            return result;
        }
    }

    private String _signConfiguration(String toSign) throws GeneralSecurityException {
        String secret = (String)Config.getInstance().getValue("workspaces.onlyoffice.secret");
        if (StringUtils.isNotBlank((CharSequence)secret)) {
            byte[] payloadBytes = toSign.getBytes(StandardCharsets.UTF_8);
            byte[] secretBytes = secret.getBytes(StandardCharsets.UTF_8);
            String payload = Base64.getUrlEncoder().withoutPadding().encodeToString(payloadBytes);
            String signingInput = __JWT_HEADER_BASE64 + "." + payload;
            byte[] signingInputBytes = signingInput.getBytes(StandardCharsets.UTF_8);
            String algorithm = "HmacSHA256";
            Mac hmac = Mac.getInstance(algorithm);
            hmac.init(new SecretKeySpec(secretBytes, algorithm));
            byte[] signatureBytes = hmac.doFinal(signingInputBytes);
            String signature = Base64.getUrlEncoder().withoutPadding().encodeToString(signatureBytes);
            String token = String.format("%s.%s.%s", __JWT_HEADER_BASE64, payload, signature);
            return token;
        }
        return null;
    }

    public boolean canBePreviewed(String resourceId) {
        if (!this.isOnlyOfficeAvailable()) {
            return false;
        }
        Resource resource = (Resource)this._resolver.resolveById(resourceId);
        List<WorkspacesHelper.FileType> allowedFileTypes = List.of(WorkspacesHelper.FileType.PDF, WorkspacesHelper.FileType.PRES, WorkspacesHelper.FileType.SPREADSHEET, WorkspacesHelper.FileType.TEXT);
        return SolrResourceGroupedMimeTypes.getGroup((String)resource.getMimeType()).map(groupMimeType -> allowedFileTypes.contains((Object)WorkspacesHelper.FileType.valueOf(groupMimeType.toUpperCase()))).orElse(false);
    }

    /*
     * Exception decompiling
     */
    public boolean generateThumbnailInCache(String projectName, String resourceId, UserIdentity user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteThumbnailInCache(String projectName, String resourceId) {
        try {
            File file = this.getThumbnailFile(projectName, resourceId);
            if (file != null && file.exists()) {
                FileUtils.forceDelete((File)file);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Can delete thumbnail in cache for project name '{}' and resource id '{}'", new Object[]{projectName, resourceId, e});
        }
    }

    public void deleteProjectThumbnailsInCache(String projectName) {
        try {
            File thumbnailDir = new File(AmetysHomeHelper.getAmetysHomeData(), "cache/workspaces/" + projectName);
            if (thumbnailDir.exists()) {
                FileUtils.forceDelete((File)thumbnailDir);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Can delete thumbnails in cache for project name '{}'", (Object)projectName, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _generatePNGFileInCache(String projectName, String uri, String fileId) throws IOException {
        Path thumbnailDir = AmetysHomeHelper.getAmetysHomeData().toPath().resolve(Path.of(WORKSPACE_PATH_CACHE, projectName, THUMBNAIL_FILE_PATH));
        Files.createDirectories(thumbnailDir, new FileAttribute[0]);
        String name = this._encodeFileId(fileId);
        URLSource source = null;
        Path tmpFile = thumbnailDir.resolve(name + ".tmp.png");
        try {
            source = (URLSource)this._sourceResolver.resolveURI(uri, null, new HashMap());
            try (InputStream is = source.getInputStream();
                 OutputStream os = Files.newOutputStream(tmpFile, new OpenOption[0]);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            Files.move(tmpFile, tmpFile.resolveSibling(name + ".png"), StandardCopyOption.REPLACE_EXISTING);
            if (source == null) return;
        }
        catch (Exception e) {
            try {
                this.getLogger().error("An error occurred generating png file with uri '{}'", (Object)uri, (Object)e);
                if (source == null) return;
            }
            catch (Throwable throwable) {
                if (source == null) throw throwable;
                this._sourceResolver.release(source);
                throw throwable;
            }
            this._sourceResolver.release((Source)source);
            return;
        }
        this._sourceResolver.release((Source)source);
        return;
    }

    private OnlyOfficeResource _getOnlyOfficeResource(String resourceId, UserIdentity user) {
        Resource resource = (Resource)this._resolver.resolveById(resourceId);
        String token = this._generateToken(resourceId, user);
        String tokenCtx = StringUtils.substringAfter((String)resourceId, (String)"://");
        String title = resource.getName();
        String fileExtension = StringUtils.substringAfterLast((String)resource.getName(), (String)".").toLowerCase();
        String key = this._onlyOfficeKeyManager.getKey(resourceId);
        String previewKey = tokenCtx + "." + Optional.ofNullable(resource.getLastModified()).map(Date::getTime).orElse(0L);
        String ooCMSUrl = (String)Config.getInstance().getValue("workspaces.onlyoffice.bo.url");
        if (StringUtils.isEmpty((CharSequence)ooCMSUrl)) {
            ooCMSUrl = (String)Config.getInstance().getValue("cms.url");
        }
        String downloadUrl = ooCMSUrl + "/_workspaces/only-office/download-resource?id=" + resourceId + "&token=" + token + "&tokenContext=" + tokenCtx;
        String callbackUrl = ooCMSUrl + "/_workspaces/only-office/response.json?id=" + resourceId + "&token=" + token + "&tokenContext=" + tokenCtx;
        return new OnlyOfficeResource(title, fileExtension, key, previewKey, downloadUrl, callbackUrl);
    }

    public File getThumbnailFile(String projectName, String resourceId) {
        File thumbnailDir = new File(AmetysHomeHelper.getAmetysHomeData(), "cache/workspaces/" + projectName + "/file-manager/thumbnail");
        if (thumbnailDir.exists()) {
            String name = this._encodeFileId(resourceId);
            return new File(thumbnailDir, name + ".png");
        }
        return null;
    }

    private String _encodeFileId(String fileId) {
        return Base64.getEncoder().withoutPadding().encodeToString(fileId.getBytes(StandardCharsets.UTF_8));
    }

    private static /* synthetic */ Lock lambda$generateThumbnailInCache$1(String __) {
        return new ReentrantLock();
    }

    private record OnlyOfficeResource(String title, String fileExtension, String key, String previewKey, String urlDownload, String callbackUrl) {
    }
}

