/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.forum;

import org.ametys.core.right.RightManager;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.workspaces.AbstractWorkspaceDAO;
import org.ametys.plugins.workspaces.forum.ForumWorkspaceModule;
import org.ametys.plugins.workspaces.forum.Thread;
import org.ametys.plugins.workspaces.forum.WorkspaceThreadUserPreferencesDAO;
import org.ametys.plugins.workspaces.forum.jcr.JCRThread;
import org.ametys.plugins.workspaces.forum.json.ThreadJSONHelper;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang.IllegalClassException;

public abstract class AbstractWorkspaceThreadDAO
extends AbstractWorkspaceDAO {
    protected ThreadJSONHelper _threadJSONHelper;
    protected WorkspaceThreadUserPreferencesDAO _workspaceThreadUserPrefDAO;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._threadJSONHelper = (ThreadJSONHelper)((Object)manager.lookup(ThreadJSONHelper.ROLE));
        this._workspaceThreadUserPrefDAO = (WorkspaceThreadUserPreferencesDAO)((Object)manager.lookup(WorkspaceThreadUserPreferencesDAO.ROLE));
    }

    protected ModifiableTraversableAmetysObject _getThreadRoot(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        ForumWorkspaceModule threadModule = (ForumWorkspaceModule)this._workspaceModuleEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        return threadModule.getModuleRoot(project, true);
    }

    protected JCRThread _getThreadByID(String threadId) {
        AmetysObject object = this._resolver.resolveById(threadId);
        if (!(object instanceof JCRThread)) {
            throw new IllegalClassException(JCRThread.class, object.getClass());
        }
        JCRThread thread = (JCRThread)object;
        return thread;
    }

    protected ModifiableResourceCollection _getModuleRoot() {
        String projectName = this._getProjectName();
        return this._getModuleRoot(projectName);
    }

    protected ModifiableResourceCollection _getModuleRoot(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        ForumWorkspaceModule forumModule = (ForumWorkspaceModule)this._workspaceModuleEP.getModule(ForumWorkspaceModule.FORUM_MODULE_ID);
        return forumModule.getModuleRoot(project, false);
    }

    protected void _checkUserRights(AmetysObject objectToCheck, String superRightId, Thread thread, String authorRightId) throws IllegalAccessException {
        UserIdentity user = this._currentUserProvider.getUser();
        if (this._rightManager.hasRight(user, superRightId, (Object)objectToCheck) == RightManager.RightResult.RIGHT_ALLOW) {
            return;
        }
        if (this._rightManager.hasRight(user, authorRightId, (Object)objectToCheck) == RightManager.RightResult.RIGHT_ALLOW && thread.getAuthor().equals((Object)user)) {
            return;
        }
        throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to do operation without convenient right [" + superRightId + "]");
    }
}

