/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.keywords;

import java.util.Collection;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.cms.tag.DefaultTag;
import org.ametys.cms.tag.Tag;
import org.ametys.cms.tag.jcr.AbstractJCRTagProvider;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.workspaces.keywords.KeywordJCR;
import org.ametys.plugins.workspaces.keywords.KeywordProviderExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class KeywordJCRProvider
extends AbstractJCRTagProvider<DefaultTag> {
    public static final String PROJECT_PLUGIN_NODE_NAME = "workspaces";
    protected AmetysObjectResolver _resolver;
    protected KeywordProviderExtensionPoint _projectTagProviderEP;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._projectTagProviderEP = (KeywordProviderExtensionPoint)((Object)smanager.lookup(KeywordProviderExtensionPoint.ROLE));
    }

    protected void _fillCache(TraversableAmetysObject parentTagNode, DefaultTag parentTag, Map<String, DefaultTag> cache) throws RepositoryException {
        for (AmetysObject child : parentTagNode.getChildren()) {
            if (!(child instanceof KeywordJCR)) continue;
            KeywordJCR jcrTag = (KeywordJCR)child;
            DefaultTag tag = new DefaultTag(jcrTag.getId(), jcrTag.getName(), parentTag, new I18nizableText(jcrTag.getTitle()), new I18nizableText(jcrTag.getDescription()));
            cache.put(child.getName(), tag);
            if (parentTag != null) {
                parentTag.addTag((Tag)tag);
            }
            this._fillCache((TraversableAmetysObject)jcrTag, tag, cache);
        }
    }

    protected ModifiableTraversableAmetysObject _getRootNode(Map<String, Object> contextualParameters, Session session) throws RepositoryException {
        try {
            ModifiableTraversableAmetysObject pluginsNode = (ModifiableTraversableAmetysObject)this._resolver.resolveByPath("/ametys:plugins", session);
            ModifiableTraversableAmetysObject pluginNode = this._getOrCreateNode(pluginsNode, PROJECT_PLUGIN_NODE_NAME, "ametys:unstructured");
            return this._getOrCreateNode(pluginNode, this._projectTagProviderEP.getTagsNodeName(), this._projectTagProviderEP.getTagsNodeType());
        }
        catch (AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to get the JCR tags root node", (Throwable)e);
        }
    }

    public Collection<DefaultTag> getTags(String tagID, Map<String, Object> contextualParameters) {
        DefaultTag tag = (DefaultTag)this.getTag(tagID, contextualParameters);
        return tag != null ? tag.getTags().values() : null;
    }
}

