/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.project.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.observation.Event;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.workspaces.members.JCRProjectMember;
import org.ametys.plugins.workspaces.members.ProjectMemberManager;
import org.ametys.plugins.workspaces.project.notification.AbstractMemberMailNotifierObserver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;

public class WelcomeMemberMailNotifierObserver
extends AbstractMemberMailNotifierObserver {
    public boolean supports(Event event) {
        return event.getId().equals("member.added") && (Boolean)Config.getInstance().getValue("workspaces.member.added.send.notification", true, (Object)false) != false;
    }

    @Override
    protected List<String> getUserToNotify(Event event, Project project) {
        GroupIdentity groupIdentity;
        Group group;
        String memberId = (String)event.getArguments().get("project.member.id");
        JCRProjectMember newMember = (JCRProjectMember)this._resolver.resolveById(memberId);
        List<User> newUsersInProject = new ArrayList<User>();
        if (JCRProjectMember.MemberType.USER == newMember.getType()) {
            User user = this._userManager.getUser(newMember.getUser());
            if (this._isUserMemberNewToProject(user.getIdentity(), project)) {
                newUsersInProject.add(user);
            }
        } else if (JCRProjectMember.MemberType.GROUP == newMember.getType() && (group = this._groupManager.getGroup(groupIdentity = newMember.getGroup())) != null && project != null) {
            newUsersInProject = this._projectMemberManager.getGroupUsersFromProject(group, project, (currentProject, identity) -> this._isGroupMemberNewToTheProject((Project)((Object)currentProject), (UserIdentity)identity, groupIdentity));
        }
        return this.getUsersEmail(newUsersInProject);
    }

    @Override
    protected I18nizableText getI18nSubject(Event event, Project project) {
        return new I18nizableText("plugin." + this._pluginName, "PROJECT_MAIL_NOTIFICATION_EVENT_SUBJECT_MEMBER_ADDED", List.of(project.getTitle()));
    }

    @Override
    protected String getMailBodyURI(Event event, Project project) {
        return "cocoon://_plugins/workspaces/notification-mail-member-event";
    }

    private boolean _isGroupMemberNewToTheProject(Project project, UserIdentity userIdentity, GroupIdentity newGroupToIgnore) {
        Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, false);
        boolean isUserOfProject = projectMembers.stream().filter(member -> JCRProjectMember.MemberType.USER == member.getType()).map(ProjectMemberManager.ProjectMember::getUser).map(User::getIdentity).filter(arg_0 -> ((UserIdentity)userIdentity).equals(arg_0)).findAny().isPresent();
        if (isUserOfProject) {
            return false;
        }
        return this._isUserMemberInAGroupMember(userIdentity, newGroupToIgnore, projectMembers);
    }

    private boolean _isUserMemberNewToProject(UserIdentity userIdentity, Project project) {
        Set<ProjectMemberManager.ProjectMember> projectMembers = this._projectMemberManager.getProjectMembers(project, false);
        return this._isUserMemberInAGroupMember(userIdentity, null, projectMembers);
    }

    private boolean _isUserMemberInAGroupMember(UserIdentity userIdentity, GroupIdentity newGroupToIgnore, Set<ProjectMemberManager.ProjectMember> projectMembers) {
        return projectMembers.stream().filter(member -> JCRProjectMember.MemberType.GROUP == member.getType()).map(ProjectMemberManager.ProjectMember::getGroup).filter(group -> newGroupToIgnore == null || !newGroupToIgnore.equals((Object)group.getIdentity())).filter(Objects::nonNull).map(Group::getUsers).flatMap(Collection::stream).filter(arg_0 -> ((UserIdentity)userIdentity).equals(arg_0)).findAny().isEmpty();
    }
}

