/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search;

import org.ametys.plugins.workspaces.search.SearchModule;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class StaticSearchModule
implements SearchModule,
Configurable,
PluginAware {
    protected String _pluginName;
    protected String _featureName;
    private String _id;
    private I18nizableText _title;
    private String _searchUrl;
    private int _limit;
    private int _minLimit;
    private int _order;

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._featureName = featureName;
        this._id = id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._title = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("title"), (String)("plugin." + this._pluginName), (String)"");
        Configuration urlConfiguration = configuration.getChild("searchUrl");
        String pluginUrl = urlConfiguration.getAttribute("plugin", this._pluginName);
        this._searchUrl = "_plugins/" + pluginUrl + "/" + urlConfiguration.getValue();
        Configuration limitConfiguration = configuration.getChild("limit");
        this._limit = limitConfiguration.getValueAsInteger();
        Configuration allModuleLimitConfiguration = configuration.getChild("minLimit", true);
        this._minLimit = allModuleLimitConfiguration.getValueAsInteger(this._limit);
        Configuration orderConfiguration = configuration.getChild("order");
        this._order = orderConfiguration.getValueAsInteger();
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getTitle() {
        return this._title;
    }

    @Override
    public String getSearchUrl() {
        return this._searchUrl;
    }

    @Override
    public int getLimit() {
        return this._limit;
    }

    @Override
    public int getMinLimit() {
        return this._minLimit;
    }

    @Override
    public int getOrder() {
        return this._order;
    }
}

