/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.search.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.query.QuerySyntaxException;

public class KeywordQuery
implements Query {
    private Query.Operator _operator;
    private List<String> _keywords;

    public KeywordQuery(String ... keywords) {
        this(Query.Operator.EQ, keywords);
    }

    public KeywordQuery(Collection<String> keywords) {
        this(Query.Operator.EQ, keywords);
    }

    public KeywordQuery(Query.Operator operator, String ... keywords) {
        this(operator, Arrays.asList(keywords));
    }

    public KeywordQuery(Query.Operator operator, Collection<String> keywords) {
        if (Query.Operator.EQ != operator && Query.Operator.NE != operator) {
            throw new IllegalArgumentException("Test operator '" + operator + "' is unknown for test's expression.");
        }
        this._operator = operator;
        this._keywords = new ArrayList<String>(keywords);
    }

    public String build() throws QuerySyntaxException {
        int count = this._keywords.size();
        StringBuilder sb = new StringBuilder();
        if (this._operator == Query.Operator.NE) {
            sb.append('-');
        }
        if (count > 1) {
            sb.append('(');
        }
        boolean first = true;
        for (String keyword : this._keywords) {
            if (!first) {
                sb.append(" OR ");
            }
            sb.append("workspace-keywords").append(':').append(keyword);
            first = false;
        }
        if (count > 1) {
            sb.append(')');
        }
        return sb.toString();
    }
}

