/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.workspaces.AbstractWorkspaceDAO;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tasks.TasksWorkspaceModule;

public abstract class AbstractWorkspaceTaskDAO
extends AbstractWorkspaceDAO {
    public static final String RIGHTS_HANDLE_TASK = "Plugin_Workspace_Handle_Task";
    public static final String RIGHTS_DELETE_TASK = "Plugin_Workspace_Delete_Task";
    public static final String RIGHTS_COMMENT_TASK = "Plugin_Workspace_Comment_Task";
    public static final String RIGHTS_HANDLE_TASK_LIST = "Plugin_Workspace_Handle_Tasks_List";
    public static final String RIGHTS_DELETE_TASK_LIST = "Plugin_Workspace_Delete_Tasks_List";
    public static final String RIGHTS_DELETE_COMMENT_TASK = "Plugin_Workspace_Delete_Comment_Task";

    protected ModifiableResourceCollection _getModuleRoot(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        TasksWorkspaceModule taskModule = (TasksWorkspaceModule)this._workspaceModuleEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        return taskModule.getModuleRoot(project, false);
    }

    protected ModifiableTraversableAmetysObject _getTasksListsRoot(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        TasksWorkspaceModule taskModule = (TasksWorkspaceModule)this._workspaceModuleEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        return taskModule.getTasksListsRoot(project, true);
    }

    protected ModifiableTraversableAmetysObject _getTasksRoot(String projectName) {
        Project project = this._projectManager.getProject(projectName);
        TasksWorkspaceModule taskModule = (TasksWorkspaceModule)this._workspaceModuleEP.getModule(TasksWorkspaceModule.TASK_MODULE_ID);
        return taskModule.getTasksRoot(project, true);
    }

    @Callable
    public Map<String, Object> getUserRights(String projectName) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        ModifiableTraversableAmetysObject tasksRoot = this._getTasksRoot(projectName);
        ModifiableTraversableAmetysObject tasksListsRoot = this._getTasksListsRoot(projectName);
        UserIdentity user = this._currentUserProvider.getUser();
        results.put("canWriteTaskList", this._rightManager.hasRight(user, RIGHTS_HANDLE_TASK_LIST, (Object)tasksListsRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canDeleteTaskList", this._rightManager.hasRight(user, RIGHTS_DELETE_TASK_LIST, (Object)tasksListsRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canWriteTask", this._rightManager.hasRight(user, RIGHTS_HANDLE_TASK, (Object)tasksRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canDeleteTask", this._rightManager.hasRight(user, RIGHTS_DELETE_TASK, (Object)tasksRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canCommentTask", this._rightManager.hasRight(user, RIGHTS_COMMENT_TASK, (Object)tasksRoot) == RightManager.RightResult.RIGHT_ALLOW);
        results.put("canDeleteCommentTask", this._rightManager.hasRight(user, RIGHTS_DELETE_COMMENT_TASK, (Object)tasksRoot) == RightManager.RightResult.RIGHT_ALLOW);
        return results;
    }
}

