/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.tasks.userprefs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.userpref.UserPreferencesException;
import org.ametys.core.userpref.UserPreferencesManager;
import org.ametys.core.util.JSONUtils;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class TasksUserPreferencesManager
implements Component,
Serviceable {
    public static final String ROLE = TasksUserPreferencesManager.class.getName();
    private CurrentUserProvider _currentUserProvider;
    private UserPreferencesManager _userPreferencesManager;
    private JSONUtils _jsonUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._jsonUtils = (JSONUtils)serviceManager.lookup(JSONUtils.ROLE);
        this._userPreferencesManager = (UserPreferencesManager)serviceManager.lookup(UserPreferencesManager.ROLE);
    }

    @Callable
    public void setUserPreferences(String siteName, String zoneItemId, List<String> projects) throws UserPreferencesException {
        UserIdentity user = this._currentUserProvider.getUser();
        if (user != null && StringUtils.isNotEmpty((CharSequence)user.getLogin()) && StringUtils.isNotEmpty((CharSequence)user.getPopulationId())) {
            HashMap<String, String> values = new HashMap<String, String>();
            Map<String, String> contextVars = this._getContextVars(siteName);
            values.put("projects", this._jsonUtils.convertObjectToJson(projects));
            this._userPreferencesManager.setUserPreferences(user, siteName + "/" + zoneItemId, contextVars, values);
        }
    }

    @Callable
    public Map<String, Object> getUserPreferences(String siteName, String zoneItemId) throws UserPreferencesException {
        HashMap<String, Object> userPreferences = new HashMap<String, Object>();
        UserIdentity user = this._currentUserProvider.getUser();
        if (user != null) {
            Map<String, String> contextVars = this._getContextVars(siteName);
            Map unTypedUserPrefs = this._userPreferencesManager.getUnTypedUserPrefs(user, siteName + "/" + zoneItemId, contextVars);
            Object[] projects = new Object[]{null};
            if (!unTypedUserPrefs.isEmpty()) {
                projects = this._jsonUtils.convertJsonToArray(this._userPreferencesManager.getUserPreferenceAsString(user, siteName + "/" + zoneItemId, contextVars, "projects"));
            }
            userPreferences.put("projects", projects);
        }
        return userPreferences;
    }

    private Map<String, String> _getContextVars(String siteName) {
        HashMap<String, String> contextVars = new HashMap<String, String>();
        contextVars.put("siteName", siteName);
        return contextVars;
    }
}

