/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.workspaces.util.StatisticsColumnType;
import org.ametys.runtime.i18n.I18nizableText;

public class StatisticColumn {
    private String _id;
    private I18nizableText _label;
    private StatisticsColumnType _type;
    private Integer _width;
    private String _renderer;
    private String _converter;
    private Boolean _hidden;
    private Boolean _editable;
    private Boolean _sortable;
    private Boolean _multiple;
    private Boolean _filter;
    private String _defaultSorter;
    private List<StatisticColumn> _subColumns;
    private String _group;

    public StatisticColumn(String id, I18nizableText label) {
        this._id = id;
        this._label = label;
        this._subColumns = new ArrayList<StatisticColumn>();
        this._filter = true;
    }

    public StatisticColumn withId(String id) {
        this._id = id;
        return this;
    }

    public StatisticColumn withLabel(I18nizableText label) {
        this._label = label;
        return this;
    }

    public StatisticColumn withType(StatisticsColumnType type) {
        this._type = type;
        return this;
    }

    public StatisticColumn withWidth(int width) {
        this._width = width;
        return this;
    }

    public StatisticColumn withRenderer(String renderer) {
        this._renderer = renderer;
        return this;
    }

    public StatisticColumn withConverter(String converter) {
        this._converter = converter;
        return this;
    }

    public StatisticColumn isHidden(boolean hidden) {
        this._hidden = hidden;
        return this;
    }

    public StatisticColumn withEditable(boolean editable) {
        this._editable = editable;
        return this;
    }

    public StatisticColumn withSortable(boolean sortable) {
        this._sortable = sortable;
        return this;
    }

    public StatisticColumn withMultiple(boolean multiple) {
        this._multiple = multiple;
        return this;
    }

    public StatisticColumn withDefaultSorter(String defaultSorter) {
        this._defaultSorter = defaultSorter;
        return this;
    }

    public StatisticColumn withGroup(String group) {
        this._group = group;
        return this;
    }

    public StatisticColumn withFilter(boolean filter) {
        this._filter = filter;
        return this;
    }

    public StatisticColumn addSubColumn(StatisticColumn subColumn) {
        this._subColumns.add(subColumn);
        return this;
    }

    public StatisticColumn addSubColumns(List<StatisticColumn> subColumns) {
        this._subColumns.addAll(subColumns);
        return this;
    }

    public String getGroup() {
        return this._group;
    }

    public String getId() {
        return this._id;
    }

    public I18nizableText getLabel() {
        return this._label;
    }

    public Map<String, Object> convertToJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", this._id);
        json.put("path", this._id);
        json.put("label", this._label);
        json.put("type", this._type != null ? this._type.getId().toLowerCase() : "");
        json.put("width", this._width);
        json.put("renderer", this._renderer);
        json.put("converter", this._converter);
        json.put("hidden", this._hidden);
        json.put("editable", this._editable);
        json.put("sortable", this._sortable);
        json.put("multiple", this._multiple);
        json.put("filter", this._filter);
        json.put("defaultSorter", this._defaultSorter);
        if (!this._subColumns.isEmpty()) {
            ArrayList<Map<String, Object>> jsonObject = new ArrayList<Map<String, Object>>();
            for (StatisticColumn column : this._subColumns) {
                jsonObject.add(column.convertToJSON());
            }
            json.put("subColumns", jsonObject);
        }
        return json;
    }
}

