/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

const activityTypeExtensionPoint = Ametys.serviceManager.lookup('org.ametys.plugins.repository.activities.ActivityTypeExtensionPoint');

logger.info("Start migration of task activities for default session");
migrateTaskActivityNodes(Repository.session);

logger.info("Start migration of task activities for live session");
migrateTaskActivityNodes(Repository.liveSession);

function migrateTaskActivityNodes(session) 
{
    let count = 0;
    const xpath = "//element(*, ametys:activity)[@ametys:activityTypeId = 'workspace.task.updated']";
    const activityNodes = Repository.query(xpath, false, session);
            
    while (activityNodes.hasNext())
    {
        let node = activityNodes.next();
        let eventId = node.getProperty("ametys:type").getString();
        
        
        if (eventId == "task.created")
        {
            node.setProperty("ametys:activityTypeId", "workspace.task.created");
        }
        
        if (eventId == "task.deleting")
        {
            node.setProperty("ametys:activityTypeId", "workspace.task.deleted");
        }
        
        count++;
    }
    
    logger.info(`${count} task activities have been migrated in ${session.getWorkspace().getName()} workspace`);
    session.save();
}
