/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Override of {@link Ametys.plugins.cms.tag.TagsTreePanel} to be able to handle project
 * @private
 */
Ext.define('Ametys.plugins.workspaces.project.helper.TagsTreePanel', {
    extend: 'Ametys.plugins.cms.tag.TagsTreePanel',

    _tagTooltipTpl : Ext.create('Ext.XTemplate', [ 
        '<tpl if="description && description != \'\'">',
           '{description}<br/>',
        '</tpl>'
    ]),
       
    _getTooltip: function(node)
    {
        var text = this._tagTooltipTpl.applyTemplate ({
            description: node.get('description')
        });
        
        return {
            title: node.get('title') + " (" + node.get('name') + ")",
            glyphIcon: node.get('tooltipIconCls'),
            imageWidth: 48,
            imageHeight: 48,
            text: text,
            inribbon: false
        };
    }
});