/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Helper for grids {@link Ametys.plugins.workspaces.project.tool.ProjectsTool} and {@link Ametys.plugins.workspaces.project.tool.StatisticsTool}
 * @private
 */
Ext.define('Ametys.plugins.workspaces.project.tool.ProjectsGridHelper', {
    singleton: true,
    
    
    /**
     * Renderer for the title
     * @param {String} value the value
     * @param {Object} metadata A collection of metadata about the current cell
     * @param {Ext.data.Model} record The record for the current row
     * @return {String} the html string used for the rendering of the label
     */
    renderTitle: function(value, metadata, record)
    {
        return '<span class="a-grid-glyph ametysicon-file98 ' + (record.data.valid ? '' : 'decorator-ametysicon-caution9 project-warning') + '"></span>' + Ext.String.escapeHtml(value);
    },
    
    /**
     * Function to render a value in bytes.
     * @param {Object} value The value
     * @param {Object} metaData A collection of metadata about the current cell
     * @param {Ext.data.Model} record The record
     */
    renderSize: function(value, metaData, record)
    {
        if (!value)
        {
            return value;
        }
        else if (value == -2)
        {
            return null;
        }
        else if (value == -1)
        {
            return '<span class="a-grid-glyph ametysicon-sign-caution "></span>' + "{{i18n PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_SIZE_ERROR}}";
        }
        else
        {
            return Ext.util.Format.fileSize(value);
        }
    },
     
    /**
     * Function to render elements number. A value of '-2' mean value should be ignored, because module is deactivated
     * @param {Object} value The value
     * @param {Object} metaData A collection of metadata about the current cell
     * @param {Ext.data.Model} record The record
     */
    renderElements: function(value, metaData, record)
    {
        if (value == -2)
        {
            return null;
        }
        else if (value == -1)
        {
            return '<span class="a-grid-glyph ametysicon-sign-caution "></span>' + "{{i18n PLUGINS_WORKSPACES_PROJECT_STATISTICS_TOOL_SIZE_ERROR}}";
        }
        else 
        {
            return value;
        }
    },
    
    /**
     * Renderer for managers
     * @param {Object[]} value the value
     * @param {Object} metadata A collection of metadata about the current cell
     * @param {Ext.data.Model} record The record for the current row
     * @return {String} the html string used for the rendering of the managers
     */
    renderManagers: function (value, metadata, record)
    {
        var names = [];
        Ext.Array.each(value, function (item, index) {
            names.push('<img src="' + Ametys.getPluginDirectPrefix('core-ui') + '/user/' + item.populationId + '/' + item.login + '/image_16" class="a-grid-icon a-grid-icon-user"/>' + item.fullname);
        })
        return names.join(", ");
    },
});
