<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">
                              
    <!-- 
    <item type="resource">
        <title>foo</title>
        <lastModified>yyyy-MM-dd'T'HH:mm:ss.SSSXXX</lastModified>
        <eventType>RESOURCE_CREATED|RESOURCE_RENAMED|RESOURCE_UPDATED|RESOURCE_DELETED</eventType>
        <author>
            <login/>
            <populationId/>
            <fullname/>
            <firstname/>
            <email/>
            ...
        </author>
        <fileType>
        <multiple>true|false</multiple>
        <comments>
            <comment>
                <datetime>
                <author>
                <content>
            </comment>
        </comments>
    <item>
     -->
    <xsl:template match="item[@type='resource']" mode="item-icon">
        <div style="width: 30px; height: 30px; display: inline-block;">
            <img width="30" height="30" src="{ametys:pluginImageBase64('workspaces', concat('img/document/type/mail/', fileType,'.png'))}" alt="" style="display: block; border: 0; outline: none; text-decoration: none;"></img>
        </div>
    </xsl:template>
    
    <!-- no separator for items with comments -->
    <xsl:template match="item[@type='resource'][comments/comment]" mode="item-separator-style"/>
    
    <xsl:template match="item[@type='resource']" mode="item-additional-content">
        <xsl:param name="isLast"/>
        
        <!-- We stick the comment inside the element -->
        <xsl:apply-templates select="comments/comment"/>
    </xsl:template>
    
</xsl:stylesheet>
