/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
import {mapState} from 'vuex';
import VuexUserMixin from './VuexUserMixin';
import AmetysFront from 'AmetysFront';

export default {
    mixins: [VuexUserMixin],
    computed: {
        ...mapState('members', {
           vuex_orig_members: state => state.members
        }),
        vuex_members: {
            get() {
                let username = this.$store.state.username;
                return this.$store.state.members.members
                    .filter(m => m.username != this.$store.state.adminLogin && m.username != username)
                    .sort((m1, m2) => { 
                        m1.notify = m1.notify || 0;
                        m2.notify = m2.notify || 0;
                        
                        if (m1.notify != m2.notify) 
                        {
                            return m2.notify - m1.notify;
                        } 
                        else if (m1.status == 'online' && m2.status != 'online')
                        {
                            return -1;
                        }
                        else if (m2.status == 'online' && m1.status != 'online')
                        {
                            return 1;
                        }   
                        else
                        {
                            return AmetysFront.Utils.deemphasize(m1.name.toLowerCase()) < AmetysFront.Utils.deemphasize(m2.name.toLowerCase()) ? -1 : 1;
                        }
                    });
            },
            set(arr) {
                this.$store.commit('members/SET_MEMBRES', arr);
            }
        }
    }
};
