/*
 *  Copyright 2019 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';
import Vuex from 'vuex';
import Mixin from './vueserve/mixins/global';
import ThreadStore from '../../_components/store/forum/thread/ThreadIndex.js';
import CommentStore from '../../_components/store/forum/comment/CommentIndex.js';
import * as TagsStore from '../../_components/store/project-tags/TagsStore';
import * as ColorsStore from '../../_components/store/project-tags/ColorsStore';
import * as ProjectMembersStore from '../../_components/store/project-members/ProjectMembersStore';
import PortalVue from 'portal-vue';
import VueSmoothScroll from 'vue2-smooth-scroll'

Vue.use(VueSmoothScroll);

Vue.config.productionTip = false;
Vue.config.devtools = true;

Vue.config.devtools = true;

import VueSanitize from "vue-sanitize";
Vue.use(VueSanitize);

Vue.use(PortalVue);
Vue.use(Vuex);
Vue.mixin(Mixin);


import './directives';
import App from './vueserve/ForumModule.vue';
import DiscussionsIcon from './vueserve/components/Forum/icons/Discussions.vue';
import QuestionsIcon from './vueserve/components/Forum/icons/Questions.vue';
import MoreIcon from './vueserve/components/Forum/icons/More.vue';
import PdfIcon from './vueserve/components/Forum/icons/Pdf.vue';
import AllThreadsIcon from './vueserve/components/Forum/icons/AllThreads.vue';
import GridModeIcon from './vueserve/components/Forum/icons/GridMode.vue';
import ListModeIcon from './vueserve/components/Forum/icons/ListMode.vue';
import CheckTickIcon from './vueserve/components/Forum/icons/CheckTick.vue';


// Init App
window['vue-forum-run'] = function (selector, config) {

  const store = new Vuex.Store({

    state: {
        threadCategories: config.threadCategories(),
    },
    modules: {
      thread: ThreadStore,
      comment: CommentStore,
      tags: TagsStore,
      members: ProjectMembersStore,
      colors: ColorsStore
    },
  });

  return new Vue({
    store,
    render: (h) => h(App),
    /* global Vuetify */
    vuetify: new Vuetify({
      icons: {
        values: {
          DISCUSSION: {
            component: DiscussionsIcon,
          },
          QUESTION: {
            component: QuestionsIcon,
          },
          allThreads: {
            component: AllThreadsIcon,
          },
          allThreadsGrey: {
            component: AllThreadsIcon,
            props: {
              svgColor: '#6D758A'
            }
          },
          gridMode: {
            component: GridModeIcon,
          },
          listMode: {
            component: ListModeIcon,
          },
          checkTick: {
            component: CheckTickIcon,
          },
          more: {
            component: MoreIcon,
          },
          pdf: {
            component: PdfIcon,
          },
        },
      },
      theme: {
        themes: {
          light: {
            primary: '#9575CD',
            teeColor: '#eeeeee',
            primaryColor: '#9575CD',
            secondaryColor: '#7F8182',
            tertiaryColor: '#fff',
            accentColor: '#6D758A',
            scrollColor: '#d8d8d8',
            whiteColor: '#FFFFFF',
            rippleColor: '#F4F1FA',
          },
          dark: {
            primary: '#9575CD',
            teeColor: '#eeeeee',
            primaryColor: '#9575CD',
            secondaryColor: '#7F8182',
            tertiaryColor: '#fff',
            accentColor: '#6D758A',
            scrollColor: '#d8d8d8',
            whiteColor: '#FFFFFF',
            rippleColor: '#F4F1FA',
          },
        },
        options: {
          customProperties: true,
        },
      },
    }),
  }).$mount(selector);
};
