/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import Vue from 'vue';

Vue.config.productionTip = false;

import Vuex from 'vuex';

Vue.use(Vuex);

import Vuetify from 'vuetify';

import * as ProjectsStore from '../../_components/store/ProjectsStore';
import * as TabsStore from '../../_components/store/mobile-layout/MobileTabsStore';

const store = new Vuex.Store({
  modules: {
    tabs: TabsStore,
    projects: ProjectsStore
  }
});

// Import Directives
import './directives';

// Vue base component
import App from './vueserve/MobileLayout';

// Init App
window['vue-mobile-layout-run'] = function (selector, config) {
  return new Vue({
    store,
    vuetify: new Vuetify({
      theme: {
        themes: {
          light: {
            primary: '#9575CD'
          },
          dark: {
            primary: '#9575CD'
          },
        },
      },
    }),
    render: h => h(App, {props: config})
  }).$mount(selector);
};
