/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.NamedResource;
import org.ametys.cms.data.RichText;
import org.ametys.cms.repository.AttachableAmetysObject;
import org.ametys.cms.repository.CommentableAmetysObject;
import org.ametys.cms.repository.ReactionableObject;
import org.ametys.cms.repository.comment.AbstractComment;
import org.ametys.cms.repository.comment.RichTextComment;
import org.ametys.cms.transformation.RichTextTransformer;
import org.ametys.cms.transformation.docbook.DocbookTransformer;
import org.ametys.core.observation.ObservationManager;
import org.ametys.core.right.RightManager;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.plugins.repository.tag.TaggableAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.plugins.workspaces.WorkspacesHelper;
import org.ametys.plugins.workspaces.project.ProjectManager;
import org.ametys.plugins.workspaces.project.modules.WorkspaceModuleExtensionPoint;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.plugins.workspaces.tags.ProjectTagsDAO;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;

public abstract class AbstractWorkspaceDAO
extends AbstractLogEnabled
implements Serviceable,
Component,
Contextualizable {
    protected AmetysObjectResolver _resolver;
    protected ObservationManager _observationManager;
    protected CurrentUserProvider _currentUserProvider;
    protected RightManager _rightManager;
    protected UserManager _userManager;
    protected WorkflowProvider _workflowProvider;
    protected WorkflowHelper _workflowHelper;
    protected ProjectManager _projectManager;
    protected Context _context;
    protected WorkspaceModuleExtensionPoint _workspaceModuleEP;
    protected ProjectTagsDAO _projectTagsDAO;
    protected WorkspacesHelper _workspaceHelper;
    protected RichTextTransformer _richTextTransformer;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._observationManager = (ObservationManager)manager.lookup(ObservationManager.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._userManager = (UserManager)manager.lookup(UserManager.ROLE);
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        this._workflowHelper = (WorkflowHelper)manager.lookup(WorkflowHelper.ROLE);
        this._projectManager = (ProjectManager)((Object)manager.lookup(ProjectManager.ROLE));
        this._workspaceModuleEP = (WorkspaceModuleExtensionPoint)((Object)manager.lookup(WorkspaceModuleExtensionPoint.ROLE));
        this._projectTagsDAO = (ProjectTagsDAO)((Object)manager.lookup(ProjectTagsDAO.ROLE));
        this._workspaceHelper = (WorkspacesHelper)((Object)manager.lookup(WorkspacesHelper.ROLE));
        this._richTextTransformer = (RichTextTransformer)manager.lookup(DocbookTransformer.ROLE);
    }

    protected String _getProjectName() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return (String)request.getAttribute("projectName");
    }

    protected Project _getProject() {
        return this._projectManager.getProject(this._getProjectName());
    }

    protected String _getSitemapLanguage() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return (String)request.getAttribute("sitemapLanguage");
    }

    protected String _getSiteName() {
        Request request = ContextHelper.getRequest((Context)this._context);
        return (String)request.getAttribute("siteName");
    }

    protected void _checkUserRights(AmetysObject objectToCheck, String rightId) throws IllegalAccessException {
        if (this._rightManager.hasRight(this._currentUserProvider.getUser(), rightId, (Object)objectToCheck) != RightManager.RightResult.RIGHT_ALLOW) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to do operation without convenient right [" + rightId + "]");
        }
    }

    protected void _checkUserReadingRights(AmetysObject objectToCheck) throws IllegalAccessException {
        if (!this._rightManager.currentUserHasReadAccess((Object)objectToCheck)) {
            throw new IllegalAccessException("User '" + this._currentUserProvider.getUser() + "' tried to do read operation without convenient right");
        }
    }

    protected List<Map<String, Object>> _handleTags(TaggableAmetysObject taggableAmetysObject, List<Object> tags) {
        return this._workspaceHelper.handleTags(taggableAmetysObject, tags);
    }

    protected void _setAttachments(AttachableAmetysObject attachableAmetysObject, List<Part> newFiles, List<String> newFileNames, List<String> deleteFiles) {
        if (!newFiles.isEmpty() || !deleteFiles.isEmpty()) {
            List attachments = attachableAmetysObject.getAttachments().stream().filter(b -> !deleteFiles.contains(b.getName())).collect(Collectors.toList());
            List fileNames = attachments.stream().map(NamedResource::getFilename).collect(Collectors.toList());
            int i = 0;
            for (Part newPart : newFiles) {
                String newName = newFileNames.get(i);
                fileNames.add(newName);
                Binary newBinary = this._partToBinary(newPart, newName);
                if (newBinary != null) {
                    attachments.add(newBinary);
                }
                ++i;
            }
            attachableAmetysObject.setAttachments(attachments);
        }
    }

    private Binary _partToBinary(Part part, String name) {
        Binary binary;
        block9: {
            if (part.isRejected()) {
                this.getLogger().error("Part {} will not be uploaded because it's rejected", (Object)part.getFileName());
                return null;
            }
            InputStream is = part.getInputStream();
            try {
                Binary binary2 = new Binary();
                binary2.setFilename(name);
                binary2.setInputStream(is);
                binary2.setLastModificationDate(ZonedDateTime.now());
                binary2.setMimeType(part.getMimeType());
                binary = binary2;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.getLogger().error("An error occurred getting binary from part {}", (Object)part.getFileName(), (Object)e);
                    return null;
                }
            }
            is.close();
        }
        return binary;
    }

    public <T extends AbstractComment> T createComment(CommentableAmetysObject<T> commentableAmetysObject, String commentText, ModifiableTraversableAmetysObject moduleRoot) {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        AbstractComment comment = commentableAmetysObject.createComment();
        this._setComment(comment, userIdentity, commentText);
        moduleRoot.saveChanges();
        return (T)comment;
    }

    public CommentableAmetysObject editComment(CommentableAmetysObject commentableAmetysObject, String commentId, String commentText, ModifiableTraversableAmetysObject moduleRoot) throws IllegalAccessException {
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        User user = this._userManager.getUser(userIdentity);
        AbstractComment comment = commentableAmetysObject.getComment(commentId);
        String authorEmail = comment.getAuthorEmail();
        if (!authorEmail.equals(user.getEmail())) {
            throw new IllegalAccessException("User '" + userIdentity + "' tried to edit an other user's comment");
        }
        if (comment.getContent().equals(commentText)) {
            return commentableAmetysObject;
        }
        comment.setContent(commentText);
        if (comment instanceof RichTextComment) {
            RichTextComment richTextComment = (RichTextComment)comment;
            this._setRichTextContent(commentText, richTextComment);
        }
        comment.setEdited(true);
        moduleRoot.saveChanges();
        return commentableAmetysObject;
    }

    private void _setRichTextContent(String commentText, RichTextComment richTextComment) {
        RichText richText = richTextComment.getRichTextContent();
        if (richText == null) {
            richText = new RichText();
        }
        try {
            this._richTextTransformer.transform(commentText, richText);
        }
        catch (IOException | AmetysRepositoryException e) {
            throw new AmetysRepositoryException("Unable to transform the text " + commentText + " into a rich text for comment " + richTextComment.getId(), e);
        }
        richTextComment.setRichTextContent(richText);
    }

    public CommentableAmetysObject deleteComment(CommentableAmetysObject commentableAmetysObject, String commentId, ModifiableTraversableAmetysObject moduleRoot) {
        AbstractComment comment = commentableAmetysObject.getComment(commentId);
        if (comment.isSubComment()) {
            AbstractComment subCom;
            AbstractComment parentComment = comment.getCommentParent();
            List subComments = parentComment.getSubComment(true, true);
            boolean hasAfterSubComments = this._hasAfterSubComments(comment, subComments);
            if (comment.hasSubComments() || hasAfterSubComments) {
                comment.setDeleted(true);
                comment.setAccepted(false);
            } else {
                comment.remove();
            }
            List currentSubComments = parentComment.getSubComment(true, true);
            Collections.sort(currentSubComments, (c1, c2) -> c2.getCreationDate().compareTo(c1.getCreationDate()));
            Iterator iterator = currentSubComments.iterator();
            while (iterator.hasNext() && (subCom = (AbstractComment)iterator.next()).isDeleted() && !subCom.hasSubComments()) {
                subCom.remove();
            }
            if (parentComment.isDeleted()) {
                this.deleteComment(commentableAmetysObject, parentComment.getId(), moduleRoot);
            }
        } else {
            List subComment = comment.getSubComment(true, true);
            boolean hasSubComments = subComment.stream().filter(c -> !c.isDeleted()).findAny().isPresent();
            if (hasSubComments) {
                comment.setDeleted(true);
                comment.setAccepted(false);
            } else {
                comment.remove();
            }
        }
        moduleRoot.saveChanges();
        return commentableAmetysObject;
    }

    protected boolean _hasAfterSubComments(AbstractComment comment, List<AbstractComment> subComments) {
        boolean hasAfterSubComments = subComments.stream().filter(c -> !c.getId().equals(comment.getId())).filter(c -> !c.isDeleted()).filter(c -> c.getCreationDate().isAfter(comment.getCreationDate())).findAny().isPresent();
        return hasAfterSubComments;
    }

    public <T extends AbstractComment> T answerComment(CommentableAmetysObject<T> commentableAmetysObject, String commentId, String commentText, ModifiableTraversableAmetysObject moduleRoot) {
        AbstractComment comment = commentableAmetysObject.getComment(commentId);
        UserIdentity userIdentity = this._currentUserProvider.getUser();
        AbstractComment subComment = comment.createSubComment();
        this._setComment(subComment, userIdentity, commentText);
        moduleRoot.saveChanges();
        return (T)subComment;
    }

    private void _setComment(AbstractComment comment, UserIdentity userIdentity, String commentText) {
        User user = this._userManager.getUser(userIdentity);
        comment.setAuthorName(user.getFullName());
        comment.setAuthorEmail(user.getEmail());
        comment.setAuthor(userIdentity);
        comment.setEmailHiddenStatus(true);
        comment.setContent(commentText);
        if (comment instanceof RichTextComment) {
            RichTextComment richTextComment = (RichTextComment)comment;
            this._setRichTextContent(commentText, richTextComment);
        }
        comment.setValidated(true);
    }

    public CommentableAmetysObject likeOrUnlikeComment(CommentableAmetysObject commentableAmetysObject, String commentId, Boolean liked, ModifiableTraversableAmetysObject moduleRoot) {
        AbstractComment comment = commentableAmetysObject.getComment(commentId);
        UserIdentity user = this._currentUserProvider.getUser();
        if (Boolean.FALSE.equals(liked) || liked == null && comment.getReactionUsers(ReactionableObject.ReactionType.LIKE).contains(user)) {
            comment.removeReaction(user, ReactionableObject.ReactionType.LIKE);
        } else {
            comment.addReaction(user, ReactionableObject.ReactionType.LIKE);
        }
        moduleRoot.saveChanges();
        return commentableAmetysObject;
    }
}

