/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.workspaces.dav;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.plugins.explorer.resources.ModifiableResourceCollection;
import org.ametys.plugins.explorer.resources.actions.ExplorerResourcesDAO;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.environment.http.HttpResponse;

public class WebdavMkcolAction
extends AbstractAction
implements Serviceable {
    private AmetysObjectResolver _resolver;
    private ExplorerResourcesDAO _resourcesDAO;
    private CurrentUserProvider _currentUserProvider;

    public void service(ServiceManager smanager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)smanager.lookup(AmetysObjectResolver.ROLE);
        this._resourcesDAO = (ExplorerResourcesDAO)smanager.lookup(ExplorerResourcesDAO.ROLE);
        this._currentUserProvider = (CurrentUserProvider)smanager.lookup(CurrentUserProvider.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HttpServletRequest request = (HttpServletRequest)objectModel.get("httprequest");
        String path = parameters.getParameter("path");
        Project project = (Project)((Object)request.getAttribute("project"));
        ModifiableResourceCollection parent = (ModifiableResourceCollection)this._resolver.resolveByPath(project.getPath() + "/ametys-internal:resources/");
        ArrayList errors = new ArrayList();
        for (String folder : path.split("/")) {
            if (folder.isEmpty()) continue;
            if (!parent.hasChild(folder)) {
                this._resourcesDAO.addResourceCollection(parent, folder, Boolean.valueOf(false), errors);
            }
            if (!errors.isEmpty()) {
                this.getLogger().error("User '" + this._currentUserProvider.getUser() + "' try create a collection named '" + folder + "' in parent '" + parent.getId() + "' but it failed with message : " + (String)errors.get(0));
                HttpResponse response = (HttpResponse)ObjectModelHelper.getResponse((Map)objectModel);
                response.setStatus(423);
                return EMPTY_MAP;
            }
            parent = (ModifiableResourceCollection)parent.getChild(folder);
        }
        return EMPTY_MAP;
    }
}

